/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.loss;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import org.openimaj.ml.linear.learner.loss.LossFunction;

public class SquareLossFunction
extends LossFunction {
    @Override
    public Matrix gradient(Matrix W) {
        return this.X.transpose().times((Matrix)this.X.times(W).minus((Ring)this.Y));
    }

    @Override
    public double eval(Matrix W) {
        Matrix v = (Matrix)this.X.times(W).minus((Ring)this.Y);
        if (this.bias != null) {
            v.plus((Ring)this.bias);
        }
        v.dotTimesEquals((Ring)v);
        return v.sumOfRows().sum();
    }

    @Override
    public boolean isMatrixLoss() {
        return false;
    }
}

