/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.init;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.Random;
import org.openimaj.math.matrix.CFMatrixUtils;
import org.openimaj.ml.linear.learner.init.InitStrategy;

public class SparseRowOnesInitStrategy
implements InitStrategy {
    MatrixFactory<? extends Matrix> smf = MatrixFactory.getSparseDefault();
    private Random random;
    private double sparcity;

    public SparseRowOnesInitStrategy(double sparcity, Random random) {
        this.random = random;
        this.sparcity = sparcity;
    }

    @Override
    public Matrix init(int rows, int cols) {
        Matrix ret = this.smf.createMatrix(rows, cols);
        Vector oneRow = CFMatrixUtils.plusInplace((Matrix)this.smf.createMatrix(1, cols), (double)1.0).getRow(0);
        for (int i = 0; i < rows; ++i) {
            if (!(this.random.nextDouble() > this.sparcity)) continue;
            ret.setRow(i, oneRow.clone());
        }
        return ret;
    }
}

