/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.data;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openimaj.ml.linear.data.BiconvexDataGenerator;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class BiconvexIncrementalDataGenerator {
    BiconvexDataGenerator dgen;
    private Map<String, Double> rety;
    private Iterator<Map<String, Map<String, Double>>> retxIter;

    public BiconvexIncrementalDataGenerator(int nusers, int nfeatures, int ntasks, double sparcity, double xsparcity, boolean indw, boolean indu, int seed, double noise) {
        this.dgen = new BiconvexDataGenerator(nusers, nfeatures, ntasks, sparcity, xsparcity, indw, indu, seed, noise);
    }

    public IndependentPair<Map<String, Map<String, Double>>, Map<String, Double>> generate() {
        while (this.retxIter == null || !this.retxIter.hasNext()) {
            this.prepareXY();
        }
        Map<String, Map<String, Double>> x = this.retxIter.next();
        return IndependentPair.pair(x, this.rety);
    }

    private void prepareXY() {
        Pair<Matrix> xy = this.dgen.generate();
        this.retxIter = this.prepareX((Matrix)xy.getFirstObject()).iterator();
        this.rety = this.prepareY((Matrix)xy.getSecondObject());
    }

    private Map<String, Double> prepareY(Matrix secondObject) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        for (MatrixEntry me : secondObject) {
            ret.put(me.getColumnIndex() + "", me.getValue());
        }
        return ret;
    }

    private List<Map<String, Map<String, Double>>> prepareX(Matrix firstObject) {
        HashMap<String, HashMap<String, Double>> ret = new HashMap<String, HashMap<String, Double>>();
        for (MatrixEntry matrixEntry : firstObject) {
            int user = matrixEntry.getColumnIndex();
            int word = matrixEntry.getRowIndex();
            double v = matrixEntry.getValue();
            if (v == 0.0) continue;
            String userName = this.userName(user);
            HashMap<String, Double> userMap = (HashMap<String, Double>)ret.get(userName);
            if (userMap == null) {
                userMap = new HashMap<String, Double>();
                ret.put(userName, userMap);
            }
            String wordName = this.wordName(word);
            userMap.put(wordName, v);
        }
        ArrayList<Map<String, Map<String, Double>>> retList = new ArrayList<Map<String, Map<String, Double>>>();
        for (Map.Entry map : ret.entrySet()) {
            HashMap userMap = new HashMap();
            userMap.put(map.getKey(), map.getValue());
            retList.add(userMap);
        }
        return retList;
    }

    private String wordName(int word) {
        return String.format("word_%d", word);
    }

    private String userName(int user) {
        return String.format("user_%d", user);
    }
}

