/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.dataset;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.experiment.annotations.DatasetDescription;

@DatasetDescription(name="Wine Data Set", description="These data are the results of a chemical analysis of wines grown in the same region in Italy but derived from three different cultivars. The analysis determined the quantities of 13 constituents found in each of the three types of wines.I think that the initial data set had around 30 variables, but for some reason I only have the 13 dimensional version. I had a list of what the 30 or so variables were, but a.) I lost it, and b.), I would not know which 13 variables are included in the set.The attributes are (dontated by Riccardo Leardi, riclea '@' anchem.unige.it )1) Alcohol2) Malic acid3) Ash4) Alcalinity of ash5) Magnesium6) Total phenols7) Flavanoids8) Nonflavanoid phenols9) Proanthocyanins10)Color intensity11)Hue12)OD280/OD315 of diluted wines13)ProlineIn a classification context, this is a well posed problem with \"well behaved\" class structures. A good data set for first testing of a new classifier, but not very challenging. ", creator="Forina, M. et al, PARVUS - ", url="http://archive.ics.uci.edu/ml/datasets/Wine", downloadUrls={"http://archive.ics.uci.edu/ml/machine-learning-databases/wine/wine.data"})
public class WineDataset
extends MapBackedDataset<Integer, ListDataset<double[]>, double[]> {
    static final Logger logger = Logger.getLogger(WineDataset.class);

    public WineDataset(Integer ... clusters) {
        this(true, clusters);
    }

    public WineDataset(boolean normalise, Integer ... clusters) {
        BufferedReader br = new BufferedReader(new InputStreamReader(WineDataset.class.getResourceAsStream("wine.data")));
        String line = null;
        Vector mean = null;
        HashSet<Integer> clusterSet = null;
        if (clusters.length != 0) {
            clusterSet = new HashSet<Integer>();
            clusterSet.addAll(Arrays.asList(clusters));
        }
        try {
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(",");
                int cluster = Integer.parseInt(parts[0].trim());
                if (clusterSet != null && !clusterSet.contains(cluster)) continue;
                double[] data = new double[parts.length - 1];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = Double.parseDouble(parts[i + 1]);
                }
                ListDataset ds = (ListDataset)this.get(cluster);
                if (ds == null) {
                    ds = new ListBackedDataset();
                    this.put(cluster, (Dataset)ds);
                }
                ds.add((Object)data);
                Vector copyArray = VectorFactory.getDefault().copyArray(data);
                if (mean == null) {
                    mean = copyArray.clone();
                    continue;
                }
                mean.plusEquals((Ring)copyArray);
            }
            mean.scaleEquals(1.0 / (double)this.numInstances());
            if (normalise) {
                this.normalise(mean);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Wine dataset failed to load", (Throwable)e);
        }
    }

    private void normalise(Vector mean) {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            double[] data = (double[])i$.next();
            for (int i = 0; i < data.length; ++i) {
                int n = i;
                data[n] = data[n] - mean.getElement(i);
            }
        }
    }
}

