/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.Image;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.image.processing.transform.AffineParams;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.TransformUtilities;

@Reference(type=ReferenceType.Article, author={"Morel, Jean-Michel", "Yu, Guoshen"}, title="{ASIFT: A New Framework for Fully Affine Invariant Image Comparison}", year="2009", journal="SIAM J. Img. Sci.", publisher="Society for Industrial and Applied Mathematics")
public abstract class AffineSimulation<I extends Image<P, I>, P> {
    protected static final float PI = (float)Math.PI;
    protected static final float InitialAntiAliasingSigma = 1.6f;

    private AffineSimulation() {
    }

    public static Point2d transformToOriginal(Point2d pt, int width, int height, float theta, float t) {
        if (t == 1.0f) {
            return pt;
        }
        return AffineSimulation.internalTransformToOriginal(pt, width, height, theta, t);
    }

    public static Point2d transformToOriginal(Point2d pt, Image<?, ?> original, float theta, float t) {
        if (t == 1.0f) {
            return pt;
        }
        return AffineSimulation.internalTransformToOriginal(pt, original.getWidth(), original.getHeight(), theta, t);
    }

    public static Point2d transformToOriginal(Point2d pt, int width, int height, AffineParams params) {
        return AffineSimulation.transformToOriginal(pt, width, height, params.theta, params.tilt);
    }

    public static Point2d transformToOriginal(Point2d pt, Image<?, ?> original, AffineParams params) {
        return AffineSimulation.transformToOriginal(pt, original.getWidth(), original.getHeight(), params.theta, params.tilt);
    }

    protected static Point2d internalTransformToOriginal(Point2d pt, int width, int height, float Rtheta, float t1) {
        float y_ori;
        float x_ori;
        if ((Rtheta = Rtheta * (float)Math.PI / 180.0f) <= 1.5707964f) {
            x_ori = 0.0f;
            y_ori = (float)((double)width * Math.sin(Rtheta) / (double)t1);
        } else {
            x_ori = (float)((double)(-width) * Math.cos(Rtheta) / 1.0);
            y_ori = (float)(((double)width * Math.sin(Rtheta) + (double)height * Math.sin(Rtheta - 1.5707964f)) / (double)t1);
        }
        float sin_Rtheta = (float)Math.sin(Rtheta);
        float cos_Rtheta = (float)Math.cos(Rtheta);
        Point2d ptout = pt.copy();
        ptout.setX(pt.getX() - x_ori);
        ptout.setY(pt.getY() - y_ori);
        ptout.setX(ptout.getX() * 1.0f);
        ptout.setY(ptout.getY() * t1);
        float tx = cos_Rtheta * ptout.getX() - sin_Rtheta * ptout.getY();
        float ty = sin_Rtheta * ptout.getX() + cos_Rtheta * ptout.getY();
        ptout.setX(tx);
        ptout.setY(ty);
        return ptout;
    }

    public static <Q extends List<T>, T extends Point2d, I extends Image<?, I>> void transformToOriginal(Q points, I original, float theta, float tilt) {
        float y_ori;
        float x_ori;
        ArrayList<Point2d> keys_to_remove = new ArrayList<Point2d>();
        if (theta <= 1.5707964f) {
            x_ori = 0.0f;
            y_ori = (float)((double)original.getWidth() * Math.sin(theta) / (double)tilt);
        } else {
            x_ori = (float)((double)(-original.getWidth()) * Math.cos(theta) / 1.0);
            y_ori = (float)(((double)original.getWidth() * Math.sin(theta) + (double)original.getHeight() * Math.sin(theta - 1.5707964f)) / (double)tilt);
        }
        float sin_Rtheta = (float)Math.sin(theta);
        float cos_Rtheta = (float)Math.cos(theta);
        for (Point2d k : points) {
            k.setX(k.getX() - x_ori);
            k.setY(k.getY() - y_ori);
            k.setX(k.getX() * 1.0f);
            k.setY(k.getY() * tilt);
            float tx = cos_Rtheta * k.getX() - sin_Rtheta * k.getY();
            float ty = sin_Rtheta * k.getX() + cos_Rtheta * k.getY();
            k.setX(tx);
            k.setY(ty);
            if (!(tx <= 0.0f || ty <= 0.0f || tx >= (float)original.getWidth()) && !(ty >= (float)original.getHeight())) continue;
            keys_to_remove.add(k);
        }
        points.removeAll(keys_to_remove);
    }

    public static <I extends Image<P, I>, P> List<I> transformImage(I image, int numTilts) {
        if (numTilts < 1) {
            throw new IllegalArgumentException("Number of tilts num_tilt should be equal or larger than 1.");
        }
        ArrayList<Object> transformed = new ArrayList<Object>();
        int num_rot1 = 0;
        int num_rot_t2 = 10;
        float t_min = 1.0f;
        float t_k = (float)Math.sqrt(2.0);
        for (int tt = 1; tt <= numTilts; ++tt) {
            float t = 1.0f * (float)Math.pow(t_k, tt - 1);
            if (t == 1.0f) {
                transformed.add(image.clone());
                continue;
            }
            num_rot1 = Math.round(10.0f * t / 2.0f);
            if (num_rot1 % 2 == 1) {
                ++num_rot1;
            }
            float delta_theta = (float)Math.PI / (float)(num_rot1 /= 2);
            for (int rr = 1; rr <= num_rot1; ++rr) {
                float theta = delta_theta * (float)(rr - 1);
                transformed.add(AffineSimulation.transformImage(image, theta, t));
            }
        }
        return transformed;
    }

    public static <I extends Image<P, I>, P> I transformImage(I image, float theta, float t) {
        float t1 = 1.0f;
        float t2 = 1.0f / t;
        I image_rotated = ProjectionProcessor.project(image, TransformUtilities.rotationMatrix((double)(-theta)));
        float sigma_aa = 1.6f * t / 2.0f;
        ((SinglebandImageProcessor.Processable)image_rotated).processInplace((SinglebandImageProcessor)new FImageConvolveSeparable(null, FGaussianConvolve.makeKernel(sigma_aa)));
        return ProjectionProcessor.project(image_rotated, TransformUtilities.scaleMatrix((double)1.0, (double)t2));
    }

    public static <I extends Image<P, I>, P> I transformImage(I image, AffineParams params) {
        return AffineSimulation.transformImage(image, params.theta, params.tilt);
    }
}

