/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.filterbank.RootFilterSetFilterBank;

public class MR8FilterBank
extends RootFilterSetFilterBank {
    @Override
    public void analyseImage(FImage image) {
        super.analyseImage(image);
        FImage[] allresponses = this.responses;
        this.responses = new FImage[8];
        int allIndex = 0;
        int idx = 0;
        for (int type = 0; type < 2; ++type) {
            for (int scale = 0; scale < SCALES.length; ++scale) {
                this.responses[idx] = allresponses[allIndex];
                ++allIndex;
                for (int orient = 1; orient < 6; ++orient) {
                    for (int y = 0; y < image.height; ++y) {
                        for (int x = 0; x < image.width; ++x) {
                            this.responses[idx].pixels[y][x] = Math.max(this.responses[idx].pixels[y][x], allresponses[allIndex].pixels[y][x]);
                        }
                    }
                    ++allIndex;
                }
                ++idx;
            }
        }
        this.responses[idx++] = allresponses[allIndex++];
        this.responses[idx++] = allresponses[allIndex++];
    }
}

