/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FImageConvolveSeparable;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class FGaussianConvolve
implements SinglebandImageProcessor<Float, FImage> {
    public static final float DEFAULT_GAUSS_TRUNCATE = 4.0f;
    protected float[] kernel;

    public FGaussianConvolve(float sigma) {
        this(sigma, 4.0f);
    }

    public FGaussianConvolve(float sigma, float truncate) {
        this.kernel = FGaussianConvolve.makeKernel(sigma, truncate);
    }

    public static float[] makeKernel(float sigma) {
        return FGaussianConvolve.makeKernel(sigma, 4.0f);
    }

    public static float[] makeKernel(float sigma, float truncate) {
        int i;
        if (sigma == 0.0f) {
            return new float[]{1.0f};
        }
        int ksize = (int)(2.0f * truncate * sigma + 1.0f);
        if (ksize % 2 == 0) {
            ++ksize;
        }
        float[] kernel = new float[ksize];
        float sum = 0.0f;
        for (i = 0; i < ksize; ++i) {
            float x = i - ksize / 2;
            kernel[i] = (float)Math.exp((double)(-x * x) / (2.0 * (double)sigma * (double)sigma));
            sum += kernel[i];
        }
        i = 0;
        while (i < ksize) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    public void processImage(FImage image) {
        FImageConvolveSeparable.convolveHorizontal(image, this.kernel);
        FImageConvolveSeparable.convolveVertical(image, this.kernel);
    }
}

