/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.mask.AbstractMaskedObject;
import org.openimaj.image.processor.ImageProcessor;

@Reference(type=ReferenceType.Article, author={"Tan, Xiaoyang", "Triggs, Bill"}, title="Enhanced local texture feature sets for face recognition under difficult lighting conditions", year="2010", journal="Trans. Img. Proc.", pages={"1635", "", "1650"}, url="http://dx.doi.org/10.1109/TIP.2010.2042645", month="June", number="6", publisher="IEEE Press", volume="19")
public class MaskedRobustContrastEqualisation
extends AbstractMaskedObject<FImage>
implements ImageProcessor<FImage> {
    double alpha = 0.1;
    double tau = 10.0;

    public MaskedRobustContrastEqualisation() {
    }

    public MaskedRobustContrastEqualisation(FImage mask) {
        super((Image)mask);
    }

    public void processImage(FImage image) {
        image.divideInplace(this.firstPassDivisor(image, (FImage)this.mask));
        image.divideInplace(this.secondPassDivisor(image, (FImage)this.mask));
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                image.pixels[y][x] = ((FImage)this.mask).pixels[y][x] == 1.0f ? (float)(this.tau * Math.tanh((double)image.pixels[y][x] / this.tau)) : 0.0f;
            }
        }
    }

    float firstPassDivisor(FImage image, FImage mask) {
        double accum = 0.0;
        int count = 0;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                if (mask.pixels[y][x] != 1.0f) continue;
                double ixy = image.pixels[y][x];
                accum += Math.pow(Math.abs(ixy), this.alpha);
                ++count;
            }
        }
        return (float)Math.pow(accum / (double)count, 1.0 / this.alpha);
    }

    float secondPassDivisor(FImage image, FImage mask) {
        double accum = 0.0;
        int count = 0;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                if (mask.pixels[y][x] != 1.0f) continue;
                double ixy = image.pixels[y][x];
                accum += Math.pow(Math.min(this.tau, Math.abs(ixy)), this.alpha);
                ++count;
            }
        }
        return (float)Math.pow(accum / (double)count, 1.0 / this.alpha);
    }
}

