/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram.binning;

import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.image.pixel.sampling.RectangleSampler;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

public class SimpleBlockStrategy
implements SpatialBinningStrategy {
    int numBlocksX;
    int numBlocksY;

    public SimpleBlockStrategy(int numBlocks) {
        this(numBlocks, numBlocks);
    }

    public SimpleBlockStrategy(int numBlocksX, int numBlocksY) {
        this.numBlocksX = numBlocksX;
        this.numBlocksY = numBlocksY;
    }

    @Override
    public Histogram extract(WindowedHistogramExtractor binnedData, Rectangle region, Histogram output) {
        float dx = region.width / (float)this.numBlocksX;
        float dy = region.height / (float)this.numBlocksY;
        int blockSize = binnedData.getNumBins();
        if (output == null || ((double[])output.values).length != blockSize * this.numBlocksX * this.numBlocksY) {
            output = new Histogram(blockSize * this.numBlocksX * this.numBlocksY);
        }
        RectangleSampler rs = new RectangleSampler(region, dx, dy, dx, dy);
        int block = 0;
        Histogram tmp = new Histogram(blockSize);
        for (Rectangle r : rs) {
            binnedData.computeHistogram(r, tmp);
            tmp.normaliseL2();
            System.arraycopy(tmp.values, 0, output.values, blockSize * block, blockSize);
            ++block;
        }
        return output;
    }
}

