/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;
import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

public class SATWindowedExtractor
implements WindowedHistogramExtractor {
    protected final SummedAreaTable[] sats;
    protected final int nbins;

    protected SATWindowedExtractor(int nbins) {
        this.nbins = nbins;
        this.sats = new SummedAreaTable[nbins];
    }

    public SATWindowedExtractor(FImage[] magnitudeMaps) {
        this.nbins = magnitudeMaps.length;
        this.sats = new SummedAreaTable[this.nbins];
        this.computeSATs(magnitudeMaps);
    }

    protected void computeSATs(FImage[] magnitudeMaps) {
        for (int i = 0; i < this.nbins; ++i) {
            this.sats[i] = new SummedAreaTable(magnitudeMaps[i]);
        }
    }

    @Override
    public int getNumBins() {
        return this.nbins;
    }

    @Override
    public Histogram computeHistogram(Rectangle roi) {
        return this.computeHistogram((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height);
    }

    @Override
    public Histogram computeHistogram(int x, int y, int w, int h) {
        Histogram hist = new Histogram(this.nbins);
        int x2 = x + w;
        int y2 = y + h;
        for (int i = 0; i < this.nbins; ++i) {
            float val = this.sats[i].calculateArea(x, y, x2, y2);
            ((double[])hist.values)[i] = Math.max(0.0f, val);
        }
        return hist;
    }

    @Override
    public void computeHistogram(int x, int y, int w, int h, Histogram hist) {
        int x2 = x + w;
        int y2 = y + h;
        double[] values = (double[])hist.values;
        for (int i = 0; i < values.length; ++i) {
            float val = this.sats[i].calculateArea(x, y, x2, y2);
            values[i] = Math.max(0.0f, val);
        }
    }

    @Override
    public void computeHistogram(Rectangle roi, Histogram histogram) {
        this.computeHistogram((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height, histogram);
    }
}

