/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import java.util.Comparator;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.SummedAreaTable;
import org.openimaj.image.analysis.algorithm.SummedSqAreaTable;
import org.openimaj.image.analysis.algorithm.TemplateMatcher;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.processing.algorithm.FourierCorrelation;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.util.FloatArrayStatsUtils;

public class FourierTemplateMatcher
implements ImageAnalyser<FImage> {
    private FourierCorrelation correlation;
    private Mode mode;
    private Rectangle searchBounds;
    private FImage responseMap;
    private int templateWidth;
    private int templateHeight;

    public FourierTemplateMatcher(FImage template, Mode mode) {
        this.correlation = new FourierCorrelation(template);
        this.mode = mode;
        this.templateWidth = template.width;
        this.templateHeight = template.height;
    }

    public FourierTemplateMatcher(FImage template, Rectangle bounds, Mode mode) {
        this(template, mode);
        this.searchBounds = bounds;
    }

    public Rectangle getSearchBounds() {
        return this.searchBounds;
    }

    public void setSearchBounds(Rectangle searchBounds) {
        this.searchBounds = searchBounds;
    }

    public void analyseImage(FImage image) {
        FImage subImage;
        if (this.searchBounds != null) {
            int halfWidth = this.templateWidth / 2;
            int halfHeight = this.templateHeight / 2;
            int x = (int)Math.max(this.searchBounds.x - (float)halfWidth, 0.0f);
            int width = (int)this.searchBounds.width + this.templateWidth;
            if (this.searchBounds.x - (float)halfWidth < 0.0f) {
                width = (int)((float)width + (this.searchBounds.x - (float)halfWidth));
            }
            if (x + width > image.width) {
                width = image.width;
            }
            int y = (int)Math.max(this.searchBounds.y - (float)halfHeight, 0.0f);
            int height = (int)this.searchBounds.height + this.templateHeight;
            if (this.searchBounds.y - (float)halfHeight < 0.0f) {
                height = (int)((float)height + (this.searchBounds.y - (float)halfHeight));
            }
            if (y + height > image.height) {
                height = image.height;
            }
            subImage = image.extractROI(x, y, width, height);
        } else {
            subImage = image.clone();
        }
        this.responseMap = (FImage)subImage.process((SinglebandImageProcessor)this.correlation);
        this.responseMap.height = this.responseMap.height - this.correlation.template.height + 1;
        this.responseMap.width = this.responseMap.width - this.correlation.template.width + 1;
        this.mode.processCorrelationMap(subImage, this.correlation.template, this.responseMap);
    }

    public FValuePixel[] getBestResponses(int numResponses) {
        FValuePixel.ReverseValueComparator comparator = this.mode.scoresAscending() ? FValuePixel.ReverseValueComparator.INSTANCE : FValuePixel.ValueComparator.INSTANCE;
        return TemplateMatcher.getBestResponses(numResponses, this.responseMap, this.getXOffset(), this.getYOffset(), (Comparator<FValuePixel>)comparator);
    }

    public int getXOffset() {
        int halfWidth = this.templateWidth / 2;
        if (this.searchBounds == null) {
            return halfWidth;
        }
        return (int)Math.max(this.searchBounds.x - (float)halfWidth, (float)halfWidth);
    }

    public int getYOffset() {
        int halfHeight = this.templateHeight / 2;
        if (this.searchBounds == null) {
            return halfHeight;
        }
        return (int)Math.max(this.searchBounds.y - (float)halfHeight, (float)halfHeight);
    }

    public FImage getResponseMap() {
        return this.responseMap;
    }

    public static enum Mode {
        SUM_SQUARED_DIFFERENCE{

            @Override
            public boolean scoresAscending() {
                return false;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
                float templateSum2;
                SummedSqAreaTable sum = new SummedSqAreaTable();
                img.analyseWith((ImageAnalyser)sum);
                float templateMean = FloatArrayStatsUtils.mean((float[][])template.pixels);
                float templateStdDev = FloatArrayStatsUtils.std((float[][])template.pixels);
                float templateNorm = templateStdDev * templateStdDev;
                templateNorm = templateSum2 = templateNorm + templateMean * templateMean;
                double invArea = 1.0 / ((double)template.width * (double)template.height);
                templateSum2 = (float)((double)templateSum2 / invArea);
                templateNorm = (float)Math.sqrt(templateNorm);
                templateNorm = (float)((double)templateNorm / Math.sqrt(invArea));
                float[][] pix = corr.pixels;
                for (int y = 0; y < corr.height; ++y) {
                    for (int x = 0; x < corr.width; ++x) {
                        double num = pix[y][x];
                        double wndSum2 = 0.0;
                        double t = sum.calculateSqSumArea(x, y, x + template.width, y + template.height);
                        num = (wndSum2 += t) - 2.0 * num + (double)templateSum2;
                        pix[y][x] = (float)num;
                    }
                }
            }
        }
        ,
        NORM_SUM_SQUARED_DIFFERENCE{

            @Override
            public boolean scoresAscending() {
                return false;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
                float templateSum2;
                SummedSqAreaTable sum = new SummedSqAreaTable();
                img.analyseWith((ImageAnalyser)sum);
                float templateMean = FloatArrayStatsUtils.mean((float[][])template.pixels);
                float templateStdDev = FloatArrayStatsUtils.std((float[][])template.pixels);
                float templateNorm = templateStdDev * templateStdDev;
                templateNorm = templateSum2 = templateNorm + templateMean * templateMean;
                double invArea = 1.0 / ((double)template.width * (double)template.height);
                templateSum2 = (float)((double)templateSum2 / invArea);
                templateNorm = (float)Math.sqrt(templateNorm);
                templateNorm = (float)((double)templateNorm / Math.sqrt(invArea));
                float[][] pix = corr.pixels;
                for (int y = 0; y < corr.height; ++y) {
                    for (int x = 0; x < corr.width; ++x) {
                        double num = pix[y][x];
                        double wndMean2 = 0.0;
                        double wndSum2 = 0.0;
                        double t = sum.calculateSqSumArea(x, y, x + template.width, y + template.height);
                        num = (wndSum2 += t) - 2.0 * num + (double)templateSum2;
                        t = Math.sqrt(Math.max(wndSum2 - wndMean2, 0.0)) * (double)templateNorm;
                        pix[y][x] = (float)(num /= t);
                    }
                }
            }
        }
        ,
        CORRELATION{

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
            }
        }
        ,
        NORM_CORRELATION{

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
                SummedSqAreaTable sum = new SummedSqAreaTable();
                img.analyseWith((ImageAnalyser)sum);
                float templateMean = FloatArrayStatsUtils.mean((float[][])template.pixels);
                float templateStdDev = FloatArrayStatsUtils.std((float[][])template.pixels);
                float templateNorm = templateStdDev * templateStdDev;
                templateNorm += templateMean * templateMean;
                double invArea = 1.0 / ((double)template.width * (double)template.height);
                templateNorm = (float)Math.sqrt(templateNorm);
                templateNorm = (float)((double)templateNorm / Math.sqrt(invArea));
                float[][] pix = corr.pixels;
                for (int y = 0; y < corr.height; ++y) {
                    for (int x = 0; x < corr.width; ++x) {
                        double num = pix[y][x];
                        double wndMean2 = 0.0;
                        double wndSum2 = 0.0;
                        double t = sum.calculateSqSumArea(x, y, x + template.width, y + template.height);
                        wndSum2 += t;
                        t = Math.sqrt(Math.max(wndSum2 - wndMean2, 0.0)) * (double)templateNorm;
                        pix[y][x] = (float)(num /= t);
                    }
                }
            }
        }
        ,
        CORRELATION_COEFFICIENT{

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
                SummedAreaTable sum = new SummedAreaTable();
                img.analyseWith((ImageAnalyser)sum);
                float templateMean = FloatArrayStatsUtils.mean((float[][])template.pixels);
                float[][] pix = corr.pixels;
                for (int y = 0; y < corr.height; ++y) {
                    for (int x = 0; x < corr.width; ++x) {
                        double num = pix[y][x];
                        double t = sum.calculateArea(x, y, x + template.width, y + template.height);
                        pix[y][x] = (float)(num -= t * (double)templateMean);
                    }
                }
            }
        }
        ,
        NORM_CORRELATION_COEFFICIENT{

            @Override
            public boolean scoresAscending() {
                return true;
            }

            @Override
            public void processCorrelationMap(FImage img, FImage template, FImage corr) {
                float templateStdDev;
                SummedSqAreaTable sum = new SummedSqAreaTable();
                img.analyseWith((ImageAnalyser)sum);
                float templateMean = FloatArrayStatsUtils.mean((float[][])template.pixels);
                float templateNorm = templateStdDev = FloatArrayStatsUtils.std((float[][])template.pixels);
                if (templateNorm == 0.0f) {
                    corr.fill(1.0f);
                    return;
                }
                double invArea = 1.0 / ((double)template.width * (double)template.height);
                templateNorm = (float)((double)templateNorm / Math.sqrt(invArea));
                float[][] pix = corr.pixels;
                for (int y = 0; y < corr.height; ++y) {
                    for (int x = 0; x < corr.width; ++x) {
                        double num = pix[y][x];
                        double t = sum.calculateSumArea(x, y, x + template.width, y + template.height);
                        double wndMean2 = t * t * invArea;
                        num -= t * (double)templateMean;
                        double wndSum2 = sum.calculateSqSumArea(x, y, x + template.width, y + template.height);
                        t = Math.sqrt(Math.max(wndSum2 - wndMean2, 0.0)) * (double)templateNorm;
                        pix[y][x] = (float)(num /= t);
                    }
                }
            }
        };


        public abstract boolean scoresAscending();

        public abstract void processCorrelationMap(FImage var1, FImage var2, FImage var3);
    }
}

