/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix.eigenvalues;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import java.util.Arrays;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class AllEigenvalues
extends Eigenvalues {
    private LAPACK lapack = LAPACK.getInstance();
    private boolean l = true;
    private boolean r = false;
    private Matrix A;

    public AllEigenvalues(Matrix A) {
        super(A.columnCount());
        assert (A.isSquare());
        this.A = A;
    }

    @Override
    public AllEigenvalues run() {
        double[] wr = new double[this.n];
        double[] wi = new double[this.n];
        intW info = new intW(0);
        double[] a = this.A.asColumnMajorArray();
        double[] vl = new double[this.l ? this.n * this.n : 0];
        double[] vr = new double[this.r ? this.n * this.n : 0];
        double[] work = this.allocateWorkspace();
        this.lapack.dgeev(this.jobv(this.l), this.jobv(this.r), this.n, a, this.n, wr, wi, vl, this.n, vr, this.n, work, work.length, info);
        if (info.val != 0) {
            throw new Error("dgeev ERRNO=" + info.val);
        }
        this.postprocess(wr, vl);
        return this;
    }

    private void postprocess(double[] wr, double[] vl) {
        int i;
        class Eigen
        implements Comparable<Eigen> {
            double value0;
            Vector vector0;

            Eigen() {
            }

            @Override
            public int compareTo(Eigen eigen) {
                return Double.compare(this.value0, eigen.value0);
            }
        }
        Object[] eigen = new Eigen[this.n];
        for (i = 0; i < this.n; ++i) {
            eigen[i] = new Eigen();
            ((Eigen)eigen[i]).value0 = wr[i];
            ((Eigen)eigen[i]).vector0 = Vector.copy(vl, i * this.n, this.n);
        }
        Arrays.sort(eigen);
        this.value = new double[this.nev];
        this.vector = new Vector[this.nev];
        for (i = 0; i < this.nev; ++i) {
            this.value[i] = ((Eigen)eigen[this.n - this.nev + i]).value0;
            this.vector[i] = ((Eigen)eigen[this.n - this.nev + i]).vector0;
        }
    }

    private String jobv(boolean canHasVectors) {
        return canHasVectors ? "V" : "N";
    }

    private double[] allocateWorkspace() {
        int lwork = (this.l || this.r ? 4 : 3) * this.n;
        double[] query = new double[1];
        intW info = new intW(0);
        this.lapack.dgeev(this.jobv(this.l), this.jobv(this.r), this.n, null, this.n, null, null, null, this.n, null, this.n, query, -1, info);
        if (info.val == 0) {
            lwork = (int)query[0];
        }
        return new double[lwork];
    }
}

