/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.DenseVector;
import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Util;
import ch.akuhn.matrix.Vector;
import java.util.Arrays;
import java.util.Iterator;

public class DenseMatrix
extends Matrix {
    protected double[][] values;

    public DenseMatrix(double[][] values) {
        this.values = values;
        this.assertInvariant();
    }

    protected void assertInvariant() throws IllegalArgumentException {
        if (this.values.length == 0) {
            return;
        }
        int m = this.values[0].length;
        for (int n = 0; n < this.values.length; ++n) {
            if (this.values[n].length == m) continue;
            throw new IllegalArgumentException();
        }
    }

    public DenseMatrix(int rows, int columns) {
        this.values = this.makeValues(rows, columns);
        this.assertInvariant();
    }

    protected double[][] makeValues(int rows, int columns) {
        return new double[rows][columns];
    }

    @Override
    public double add(int row, int column, double value) {
        double[] dArray = this.values[row];
        int n = column;
        double d = dArray[n] + value;
        dArray[n] = d;
        return d;
    }

    @Override
    public int columnCount() {
        return this.values[0].length;
    }

    @Override
    public double get(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public double put(int row, int column, double value) {
        double d = value;
        this.values[row][column] = d;
        return d;
    }

    @Override
    public Iterable<Vector> rows() {
        return new Iterable<Vector>(){

            @Override
            public Iterator<Vector> iterator() {
                return new Iterator<Vector>(){
                    int i = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Vector next() {
                        return new DenseVector(DenseMatrix.this.values[this.i++]);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < DenseMatrix.this.values.length;
                    }
                };
            }
        };
    }

    @Override
    public int rowCount() {
        return this.values.length;
    }

    @Override
    public int used() {
        throw null;
    }

    @Override
    public double[][] unwrap() {
        return this.values;
    }

    public void fill(double constant) {
        for (double[] row : this.values) {
            Arrays.fill(row, constant);
        }
    }

    public void applyMultiplication(double d) {
        Util.times(this.values, d);
    }

    @Override
    public Matrix newInstance(int rows, int cols) {
        return new DenseMatrix(rows, cols);
    }
}

