/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.Set;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.test.Assert;
import org.opengis.test.Validator;
import org.opengis.test.ValidatorContainer;
import org.opengis.util.GenericName;

public abstract class ReferencingValidator
extends Validator {
    public ReferencingValidator(ValidatorContainer validatorContainer, String string) {
        super(validatorContainer, string);
    }

    public final void dispatchObject(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof CoordinateReferenceSystem) {
            this.container.crs.dispatch((CoordinateReferenceSystem)identifiedObject);
        } else if (identifiedObject instanceof CoordinateSystem) {
            this.container.cs.dispatch((CoordinateSystem)identifiedObject);
        } else if (identifiedObject instanceof CoordinateSystemAxis) {
            this.container.cs.validate((CoordinateSystemAxis)identifiedObject);
        } else if (identifiedObject instanceof Datum) {
            this.container.datum.dispatch((Datum)identifiedObject);
        } else if (identifiedObject instanceof Ellipsoid) {
            this.container.datum.validate((Ellipsoid)identifiedObject);
        } else if (identifiedObject instanceof PrimeMeridian) {
            this.container.datum.validate((PrimeMeridian)identifiedObject);
        } else if (identifiedObject instanceof GeneralParameterDescriptor) {
            this.container.parameter.dispatch((GeneralParameterDescriptor)identifiedObject);
        } else if (identifiedObject instanceof CoordinateOperation) {
            this.container.coordinateOperation.dispatch((CoordinateOperation)identifiedObject);
        } else if (identifiedObject instanceof OperationMethod) {
            this.container.coordinateOperation.validate((OperationMethod)identifiedObject);
        } else if (identifiedObject instanceof ReferenceSystem) {
            this.validateReferenceSystem((ReferenceSystem)identifiedObject);
        } else if (identifiedObject != null) {
            this.validateIdentifiedObject(identifiedObject);
        }
    }

    public void validate(ReferenceIdentifier referenceIdentifier) {
        if (referenceIdentifier == null) {
            return;
        }
        this.mandatory("ReferenceIdentifier: must have a code.", referenceIdentifier.getCode());
        this.container.citation.validate(referenceIdentifier.getAuthority());
    }

    final void validateReferenceSystem(ReferenceSystem referenceSystem) {
        this.validateIdentifiedObject((IdentifiedObject)referenceSystem);
        this.container.naming.validate(referenceSystem.getScope());
        this.container.extent.validate(referenceSystem.getDomainOfValidity());
    }

    final void validateIdentifiedObject(IdentifiedObject identifiedObject) {
        ReferenceIdentifier referenceIdentifier;
        Object object;
        this.validate(identifiedObject.getName());
        Set set = identifiedObject.getIdentifiers();
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                referenceIdentifier = (ReferenceIdentifier)object.next();
                Assert.assertNotNull((String)"IdentifiedObject: getIdentifiers() can not contain null element.", (Object)referenceIdentifier);
                this.validate(referenceIdentifier);
            }
        }
        if ((object = identifiedObject.getAlias()) != null) {
            referenceIdentifier = object.iterator();
            while (referenceIdentifier.hasNext()) {
                GenericName genericName = (GenericName)referenceIdentifier.next();
                Assert.assertNotNull((String)"IdentifiedObject: getAlias() can not contain null element.", (Object)object);
                this.container.naming.dispatch(genericName);
            }
        }
        this.container.naming.validate(identifiedObject.getRemarks());
    }
}

