/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.Factory;

public class Units
implements Factory {
    private static Units DEFAULT;
    private final Unit<Length> metre;
    private final Unit<Length> kilometre;
    private final Unit<Angle> radian;
    private final Unit<Angle> degree;
    private final Unit<Time> second;
    private final Unit<Time> day;
    private final Unit<Dimensionless> one;
    private final Unit<Dimensionless> ppm;

    protected Units(SystemOfUnits systemOfUnits) {
        this.metre = systemOfUnits.getUnit(Length.class);
        this.radian = systemOfUnits.getUnit(Angle.class);
        this.second = systemOfUnits.getUnit(Time.class);
        this.one = Units.getDimensionless(systemOfUnits);
        this.kilometre = this.metre.multiply(1000.0);
        this.degree = this.radian.multiply(Math.PI / 180);
        this.day = this.second.multiply(86400.0);
        this.ppm = this.one.divide(1000000.0);
    }

    public static synchronized Units getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new Units(ServiceProvider.current().getSystemOfUnitsService().getSystemOfUnits());
        }
        return DEFAULT;
    }

    private static Unit<Dimensionless> getDimensionless(SystemOfUnits systemOfUnits) {
        Unit unit = systemOfUnits.getUnit(Dimensionless.class);
        if (unit == null) {
            try {
                unit = ((Unit)Class.forName("tec.units.ri.AbstractUnit").getField("ONE").get(null)).asType(Dimensionless.class);
            }
            catch (ClassCastException | ReflectiveOperationException exception) {
                throw new IllegalArgumentException("Can not create a dimensionless unit from the given provider.");
            }
        }
        return unit;
    }

    public Citation getVendor() {
        return null;
    }

    public Unit<Length> metre() {
        return this.metre;
    }

    public Unit<Length> kilometre() {
        return this.kilometre;
    }

    public Unit<Angle> radian() {
        return this.radian;
    }

    public Unit<Angle> degree() {
        return this.degree;
    }

    public Unit<Time> second() {
        return this.second;
    }

    public Unit<Time> day() {
        return this.day;
    }

    public Unit<Dimensionless> one() {
        return this.one;
    }

    public Unit<Dimensionless> ppm() {
        return this.ppm;
    }
}

