/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@Beta
public abstract class ElementCountConstraint {
    ElementCountConstraint() {
    }

    public static @NonNull ElementCountConstraint atLeast(int minElements) {
        return new Min(minElements);
    }

    public static @NonNull ElementCountConstraint atMost(int maxElements) {
        return new Max(maxElements);
    }

    public static @NonNull ElementCountConstraint inRange(int minElements, int maxElements) {
        return new MinMax(minElements, maxElements);
    }

    public static @NonNull Optional<ElementCountConstraint> forNullable(@Nullable Integer minElements, @Nullable Integer maxElements) {
        if (minElements == null) {
            return maxElements != null ? Optional.of(new Max(maxElements)) : Optional.empty();
        }
        return Optional.of(maxElements != null ? new MinMax(minElements, maxElements) : new Min(minElements));
    }

    public abstract @Nullable Integer getMinElements();

    public abstract @Nullable Integer getMaxElements();

    public final int hashCode() {
        return Objects.hash(this.getMinElements(), this.getMaxElements());
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementCountConstraint)) {
            return false;
        }
        ElementCountConstraint other = (ElementCountConstraint)obj;
        return Objects.equals(this.getMinElements(), other.getMinElements()) && Objects.equals(this.getMaxElements(), other.getMaxElements());
    }

    public final String toString() {
        return MoreObjects.toStringHelper(ElementCountConstraint.class).omitNullValues().add("minElements", (Object)this.getMinElements()).add("maxElements", (Object)this.getMaxElements()).toString();
    }

    private static final class MinMax
    extends ElementCountConstraint {
        private final int minElements;
        private final int maxElements;

        MinMax(int minElements, int maxElements) {
            Preconditions.checkArgument((minElements >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((maxElements >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((minElements <= maxElements ? 1 : 0) != 0);
            this.minElements = minElements;
            this.maxElements = maxElements;
        }

        @Override
        public Integer getMinElements() {
            return this.minElements;
        }

        @Override
        public Integer getMaxElements() {
            return this.maxElements;
        }
    }

    private static final class Max
    extends ElementCountConstraint {
        private final int maxElements;

        Max(int maxElements) {
            Preconditions.checkArgument((maxElements >= 0 ? 1 : 0) != 0);
            this.maxElements = maxElements;
        }

        @Override
        public Integer getMinElements() {
            return null;
        }

        @Override
        public Integer getMaxElements() {
            return this.maxElements;
        }
    }

    private static final class Min
    extends ElementCountConstraint {
        private final int minElements;

        Min(int minElements) {
            Preconditions.checkArgument((minElements >= 0 ? 1 : 0) != 0);
            this.minElements = minElements;
        }

        @Override
        public Integer getMinElements() {
            return this.minElements;
        }

        @Override
        public Integer getMaxElements() {
            return null;
        }
    }
}

