/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;

@Beta
@ThreadSafe
public final class SharedCodecCache<T>
extends CodecCache<T> {
    private final Cache<TypeDefinition<?>, T> simpleCodecs = CacheBuilder.newBuilder().weakKeys().softValues().build();
    private final Cache<TypedSchemaNode, T> complexCodecs = CacheBuilder.newBuilder().weakKeys().softValues().build();

    @Override
    public T lookupComplex(TypedSchemaNode schema) {
        return (T)this.complexCodecs.getIfPresent((Object)schema);
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return (T)this.simpleCodecs.getIfPresent(type);
    }

    @Override
    T getComplex(TypedSchemaNode schema, T codec) {
        try {
            return (T)this.complexCodecs.get((Object)schema, () -> codec);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(e);
        }
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        try {
            return (T)this.simpleCodecs.get(type, () -> codec);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(e);
        }
    }
}

