/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;

@Beta
@ThreadSafe
public final class PrecomputedCodecCache<T>
extends CodecCache<T> {
    private final Map<TypeDefinition<?>, T> simpleCodecs;
    private final Map<TypedSchemaNode, T> complexCodecs;

    PrecomputedCodecCache(Map<TypeDefinition<?>, T> simpleCodecs, Map<TypedSchemaNode, T> complexCodecs) {
        this.simpleCodecs = (Map)Preconditions.checkNotNull(simpleCodecs);
        this.complexCodecs = (Map)Preconditions.checkNotNull(complexCodecs);
    }

    @Override
    T lookupComplex(TypedSchemaNode schema) {
        T ret = this.complexCodecs.get(schema);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"No codec available for schema %s", (Object)schema);
        return ret;
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return this.simpleCodecs.get(type);
    }

    @Override
    T getComplex(TypedSchemaNode schema, T codec) {
        throw new IllegalStateException("Uncached codec for " + schema);
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        throw new IllegalStateException("Uncached codec for " + type);
    }

    public int complexSize() {
        return this.complexCodecs.size();
    }

    public int simpleSize() {
        return this.simpleCodecs.size();
    }
}

