/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.PrecomputedCodecCache;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;

@Beta
@NotThreadSafe
public final class LazyCodecCache<T>
extends CodecCache<T> {
    private final Map<TypedSchemaNode, T> complexCodecs = new IdentityHashMap<TypedSchemaNode, T>();
    private final Map<TypeDefinition<?>, T> simpleCodecs = new IdentityHashMap();

    @Override
    T getComplex(TypedSchemaNode schema, T codec) {
        return (T)this.complexCodecs.computeIfAbsent(schema, any -> codec);
    }

    @Override
    T lookupComplex(TypedSchemaNode schema) {
        return this.complexCodecs.get(schema);
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return this.simpleCodecs.get(type);
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        return (T)this.simpleCodecs.computeIfAbsent(type, any -> codec);
    }

    public PrecomputedCodecCache<T> toPrecomputed() {
        return new PrecomputedCodecCache<T>(this.simpleCodecs, this.complexCodecs);
    }
}

