/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Beta
@NonNullByDefault
@ThreadSafe
public final class IdentityCodecUtil {
    private IdentityCodecUtil() {
        throw new UnsupportedOperationException();
    }

    public static IdentitySchemaNode parseIdentity(String value, SchemaContext schemaContext, Function<String, QNameModule> prefixToModule) {
        QName qname = QNameCodecUtil.decodeQName(value, prefixToModule);
        Module module = schemaContext.findModuleByNamespaceAndRevision(qname.getNamespace(), qname.getRevision());
        Preconditions.checkState((module != null ? 1 : 0) != 0, (String)"Parsed QName %s refers to a non-existent module", (Object)qname);
        for (IdentitySchemaNode identity : module.getIdentities()) {
            if (!qname.equals((Object)identity.getQName())) continue;
            return identity;
        }
        throw new IllegalArgumentException("Parsed QName " + qname + " does not refer to a valid identity");
    }
}

