/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public final class ParserStreamUtils {
    private ParserStreamUtils() {
        throw new UnsupportedOperationException("Utility class should not be instantiated.");
    }

    public static Deque<DataSchemaNode> findSchemaNodeByNameAndNamespace(DataSchemaNode dataSchemaNode, String childName, URI namespace) {
        ArrayDeque<DataSchemaNode> result = new ArrayDeque<DataSchemaNode>();
        ArrayList<ChoiceSchemaNode> childChoices = new ArrayList<ChoiceSchemaNode>();
        DataSchemaNode potentialChildNode = null;
        if (dataSchemaNode instanceof DataNodeContainer) {
            for (DataSchemaNode childNode : ((DataNodeContainer)dataSchemaNode).getChildNodes()) {
                if (childNode instanceof ChoiceSchemaNode) {
                    childChoices.add((ChoiceSchemaNode)childNode);
                    continue;
                }
                QName childQName = childNode.getQName();
                if (!childQName.getLocalName().equals(childName) || !childQName.getNamespace().equals(namespace) || potentialChildNode != null && !childQName.getRevision().after(potentialChildNode.getQName().getRevision())) continue;
                potentialChildNode = childNode;
            }
        }
        if (potentialChildNode != null) {
            result.push(potentialChildNode);
            return result;
        }
        for (ChoiceSchemaNode choiceNode : childChoices) {
            for (ChoiceCaseNode concreteCase : choiceNode.getCases()) {
                Deque<DataSchemaNode> resultFromRecursion = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)concreteCase, childName, namespace);
                if (resultFromRecursion.isEmpty()) continue;
                resultFromRecursion.push((DataSchemaNode)concreteCase);
                resultFromRecursion.push((DataSchemaNode)choiceNode);
                return resultFromRecursion;
            }
        }
        return result;
    }
}

