/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class DataSchemaContextTree {
    private static final LoadingCache<SchemaContext, DataSchemaContextTree> TREES = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<SchemaContext, DataSchemaContextTree>(){

        public DataSchemaContextTree load(@Nonnull SchemaContext key) throws Exception {
            return new DataSchemaContextTree(key);
        }
    });
    private final DataSchemaContextNode<?> root;

    private DataSchemaContextTree(SchemaContext ctx) {
        this.root = DataSchemaContextNode.from(ctx);
    }

    @Nonnull
    public static DataSchemaContextTree from(@Nonnull SchemaContext ctx) {
        return (DataSchemaContextTree)TREES.getUnchecked((Object)ctx);
    }

    public DataSchemaContextNode<?> getChild(YangInstanceIdentifier path) {
        DataSchemaContextNode<?> currentOp = this.root;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            currentOp = currentOp.getChild(arg);
        }
        return currentOp;
    }

    public DataSchemaContextNode<?> getRoot() {
        return this.root;
    }
}

