/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AnyXmlContextNode;
import org.opendaylight.yangtools.yang.data.util.AugmentationContextNode;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeContextNode;
import org.opendaylight.yangtools.yang.data.util.ContainerContextNode;
import org.opendaylight.yangtools.yang.data.util.LeafContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnkeyedListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

public abstract class DataSchemaContextNode<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final T identifier;
    private final DataSchemaNode dataSchemaNode;

    public T getIdentifier() {
        return this.identifier;
    }

    protected DataSchemaContextNode(T identifier, SchemaNode schema) {
        this.identifier = identifier;
        this.dataSchemaNode = schema instanceof DataSchemaNode ? (DataSchemaNode)schema : null;
    }

    public boolean isMixin() {
        return false;
    }

    public boolean isKeyedEntry() {
        return false;
    }

    protected Set<QName> getQNameIdentifiers() {
        return Collections.singleton(this.identifier.getNodeType());
    }

    @Nullable
    public abstract DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument var1);

    @Nullable
    public abstract DataSchemaContextNode<?> getChild(QName var1);

    public abstract boolean isLeaf();

    @Nullable
    public DataSchemaNode getDataSchemaNode() {
        return this.dataSchemaNode;
    }

    static DataSchemaNode findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        if (potential == null) {
            FluentIterable choices = FluentIterable.from((Iterable)parent.getChildNodes()).filter(ChoiceSchemaNode.class);
            potential = DataSchemaContextNode.findChoice((Iterable<ChoiceSchemaNode>)choices, child);
        }
        return potential;
    }

    static DataSchemaContextNode<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        DataSchemaNode result = DataSchemaContextNode.findChildSchemaNode(schema, child);
        if (result != null && schema instanceof DataSchemaNode && result.isAugmenting()) {
            return DataSchemaContextNode.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return DataSchemaContextNode.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        ChoiceSchemaNode foundChoice = null;
        block0: for (ChoiceSchemaNode choice : choices) {
            for (ChoiceCaseNode caze : choice.getCases()) {
                if (DataSchemaContextNode.findChildSchemaNode((DataNodeContainer)caze, child) == null) continue;
                foundChoice = choice;
                break block0;
            }
        }
        return foundChoice;
    }

    public static YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchema augmentation) {
        ImmutableSet.Builder potentialChildren = ImmutableSet.builder();
        for (DataSchemaNode child : augmentation.getChildNodes()) {
            potentialChildren.add((Object)child.getQName());
        }
        return new YangInstanceIdentifier.AugmentationIdentifier((Set)potentialChildren.build());
    }

    static DataNodeContainer augmentationProxy(AugmentationSchema augmentation, DataNodeContainer schema) {
        HashSet<DataSchemaNode> children = new HashSet<DataSchemaNode>();
        for (DataSchemaNode augNode : augmentation.getChildNodes()) {
            children.add(schema.getDataChildByName(augNode.getQName()));
        }
        return new EffectiveAugmentationSchema(augmentation, children);
    }

    @Nullable
    static DataSchemaContextNode<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        AugmentationSchema augmentation = null;
        for (AugmentationSchema aug : parentAug.getAvailableAugmentations()) {
            DataSchemaNode potential = aug.getDataChildByName(child.getQName());
            if (potential == null) continue;
            augmentation = aug;
            break;
        }
        if (augmentation != null) {
            return new AugmentationContextNode(augmentation, parent);
        }
        return DataSchemaContextNode.fromDataSchemaNode(child);
    }

    @Nullable
    public static DataSchemaContextNode<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new ContainerContextNode((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return DataSchemaContextNode.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new LeafContextNode((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new ChoiceNodeContextNode((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return DataSchemaContextNode.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXmlContextNode((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    private static DataSchemaContextNode<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinContextNode(potential);
        }
        if (potential.isUserOrdered()) {
            return new OrderedMapMixinContextNode(potential);
        }
        return new UnorderedMapMixinContextNode(potential);
    }

    private static DataSchemaContextNode<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        if (potential.isUserOrdered()) {
            return new OrderedLeafListMixinContextNode(potential);
        }
        return new UnorderedLeafListMixinContextNode(potential);
    }

    public static DataSchemaContextNode<?> from(SchemaContext ctx) {
        return new ContainerContextNode((ContainerSchemaNode)ctx);
    }
}

