/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree.spi;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.AbstractTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ValueNode
extends AbstractTreeNode {
    private static final Logger LOG = LoggerFactory.getLogger(ValueNode.class);

    protected ValueNode(NormalizedNode<?, ?> data, Version version) {
        super(data, version);
    }

    @Override
    public Optional<TreeNode> getChild(YangInstanceIdentifier.PathArgument childId) {
        LOG.warn("Attempted to access child {} of value-node {}", (Object)childId, (Object)this);
        return Optional.empty();
    }

    @Override
    public Version getSubtreeVersion() {
        return this.getVersion();
    }

    @Override
    public MutableTreeNode mutable() {
        throw new UnsupportedOperationException(String.format("Attempted to mutate value-node %s", this));
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("value", this.getData());
    }
}

