/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.SingletonSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.AIv1;
import org.opendaylight.yangtools.yang.data.api.FixedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.NIPv2;
import org.opendaylight.yangtools.yang.data.api.NIVv1;
import org.opendaylight.yangtools.yang.data.api.NIv1;
import org.opendaylight.yangtools.yang.data.api.StackedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YIDv1;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifierBuilder;

public abstract class YangInstanceIdentifier
implements Path<YangInstanceIdentifier>,
Immutable,
Serializable {
    private static final AtomicReferenceFieldUpdater<YangInstanceIdentifier, String> TOSTRINGCACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(YangInstanceIdentifier.class, String.class, "toStringCache");
    private static final long serialVersionUID = 4L;
    private final int hash;
    private volatile transient String toStringCache = null;

    YangInstanceIdentifier(int hash) {
        this.hash = hash;
    }

    public static @NonNull YangInstanceIdentifier empty() {
        return FixedYangInstanceIdentifier.EMPTY_INSTANCE;
    }

    abstract @NonNull YangInstanceIdentifier createRelativeIdentifier(int var1);

    abstract @Nullable Collection<PathArgument> tryPathArguments();

    abstract @Nullable Collection<PathArgument> tryReversePathArguments();

    public abstract boolean isEmpty();

    @Beta
    public abstract @NonNull YangInstanceIdentifier toOptimized();

    public abstract @Nullable YangInstanceIdentifier getParent();

    public abstract @NonNull YangInstanceIdentifier getAncestor(int var1);

    public abstract @NonNull List<PathArgument> getPathArguments();

    public abstract @NonNull List<PathArgument> getReversePathArguments();

    public abstract PathArgument getLastPathArgument();

    public static @NonNull YangInstanceIdentifier create(Iterable<? extends PathArgument> path) {
        if (Iterables.isEmpty(path)) {
            return YangInstanceIdentifier.empty();
        }
        HashCodeBuilder hash = new HashCodeBuilder();
        for (PathArgument pathArgument : path) {
            hash.addArgument((Object)pathArgument);
        }
        return FixedYangInstanceIdentifier.create(path, hash.build());
    }

    public static @NonNull YangInstanceIdentifier create(PathArgument ... path) {
        return YangInstanceIdentifier.create(Arrays.asList(path));
    }

    public static @NonNull YangInstanceIdentifier createReverse(Deque<PathArgument> pathTowardsRoot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)pathTowardsRoot.size());
        pathTowardsRoot.descendingIterator().forEachRemaining(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return YangInstanceIdentifier.create((Iterable<? extends PathArgument>)builder.build());
    }

    public static <T> @NonNull YangInstanceIdentifier createReverse(Deque<? extends T> stackTowardsRoot, Function<T, PathArgument> function) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)stackTowardsRoot.size());
        Iterator<T> it = stackTowardsRoot.descendingIterator();
        while (it.hasNext()) {
            builder.add((Object)function.apply(it.next()));
        }
        return YangInstanceIdentifier.create((Iterable<? extends PathArgument>)builder.build());
    }

    boolean pathArgumentsEqual(YangInstanceIdentifier other) {
        return Iterables.elementsEqual(this.getPathArguments(), other.getPathArguments());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangInstanceIdentifier)) {
            return false;
        }
        YangInstanceIdentifier other = (YangInstanceIdentifier)obj;
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return this.pathArgumentsEqual(other);
    }

    public final @NonNull YangInstanceIdentifier node(QName name) {
        return this.node(new NodeIdentifier(name));
    }

    public final @NonNull YangInstanceIdentifier node(PathArgument arg) {
        return new StackedYangInstanceIdentifier(this, arg, HashCodeBuilder.nextHashCode((int)this.hash, (Object)arg));
    }

    public Optional<YangInstanceIdentifier> relativeTo(YangInstanceIdentifier ancestor) {
        if (this == ancestor) {
            return Optional.of(YangInstanceIdentifier.empty());
        }
        if (ancestor.isEmpty()) {
            return Optional.of(this);
        }
        Iterator<PathArgument> lit = this.getPathArguments().iterator();
        Iterator<PathArgument> oit = ancestor.getPathArguments().iterator();
        int common = 0;
        while (oit.hasNext()) {
            if (!lit.hasNext() || !lit.next().equals(oit.next())) {
                return Optional.empty();
            }
            ++common;
        }
        if (common == 0) {
            return Optional.of(this);
        }
        if (!lit.hasNext()) {
            return Optional.of(YangInstanceIdentifier.empty());
        }
        return Optional.of(this.createRelativeIdentifier(common));
    }

    public final boolean contains(YangInstanceIdentifier other) {
        if (this == other) {
            return true;
        }
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"other should not be null");
        Iterator<PathArgument> lit = this.getPathArguments().iterator();
        Iterator<PathArgument> oit = other.getPathArguments().iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            if (lit.next().equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String ret = this.toStringCache;
        if (ret == null) {
            StringBuilder builder = new StringBuilder("/");
            PathArgument prev = null;
            for (PathArgument argument : this.getPathArguments()) {
                if (prev != null) {
                    builder.append('/');
                }
                builder.append(argument.toRelativeString(prev));
                prev = argument;
            }
            ret = builder.toString();
            TOSTRINGCACHE_UPDATER.lazySet(this, ret);
        }
        return ret;
    }

    public final int hashCode() {
        return this.hash;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static int hashCode(Object value) {
        if (value == null) {
            return 0;
        }
        if (byte[].class.equals(value.getClass())) {
            return Arrays.hashCode((byte[])value);
        }
        if (value.getClass().isArray()) {
            int hash = 0;
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                hash += Objects.hashCode(Array.get(value, i));
            }
            return hash;
        }
        return Objects.hashCode(value);
    }

    final Object writeReplace() {
        return new YIDv1(this);
    }

    public static @NonNull YangInstanceIdentifier of(QName name) {
        return YangInstanceIdentifier.create(new NodeIdentifier(name));
    }

    public static @NonNull InstanceIdentifierBuilder builder() {
        return new YangInstanceIdentifierBuilder();
    }

    public static @NonNull InstanceIdentifierBuilder builder(YangInstanceIdentifier origin) {
        return new YangInstanceIdentifierBuilder(origin.getPathArguments(), origin.hashCode());
    }

    public static interface InstanceIdentifierBuilder
    extends Builder<YangInstanceIdentifier> {
        public @NonNull InstanceIdentifierBuilder node(PathArgument var1);

        public @NonNull InstanceIdentifierBuilder node(QName var1);

        public @NonNull InstanceIdentifierBuilder nodeWithKey(QName var1, Map<QName, Object> var2);

        public @NonNull InstanceIdentifierBuilder nodeWithKey(QName var1, QName var2, Object var3);

        @Beta
        public @NonNull InstanceIdentifierBuilder append(Collection<? extends PathArgument> var1);

        @Beta
        default public @NonNull InstanceIdentifierBuilder append(PathArgument ... args) {
            return this.append(Arrays.asList(args));
        }

        public YangInstanceIdentifier build();
    }

    public static final class AugmentationIdentifier
    implements PathArgument {
        private static final long serialVersionUID = -8122335594681936939L;
        private static final LoadingCache<ImmutableSet<QName>, AugmentationIdentifier> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ImmutableSet<QName>, AugmentationIdentifier>(){

            public AugmentationIdentifier load(ImmutableSet<QName> key) {
                return new AugmentationIdentifier(key);
            }
        });
        private final @NonNull ImmutableSet<QName> childNames;

        @Override
        public QName getNodeType() {
            throw new UnsupportedOperationException("Augmentation node has no QName");
        }

        public AugmentationIdentifier(ImmutableSet<QName> childNames) {
            this.childNames = Objects.requireNonNull(childNames);
        }

        public AugmentationIdentifier(Set<QName> childNames) {
            this.childNames = ImmutableSet.copyOf(childNames);
        }

        public static @NonNull AugmentationIdentifier create(ImmutableSet<QName> childNames) {
            return (AugmentationIdentifier)CACHE.getUnchecked(childNames);
        }

        public static @NonNull AugmentationIdentifier create(Set<QName> childNames) {
            AugmentationIdentifier existing = (AugmentationIdentifier)CACHE.getIfPresent(childNames);
            return existing != null ? existing : AugmentationIdentifier.create((ImmutableSet<QName>)ImmutableSet.copyOf(childNames));
        }

        public @NonNull Set<QName> getPossibleChildNames() {
            return this.childNames;
        }

        public String toString() {
            return "AugmentationIdentifier{childNames=" + this.childNames + "}";
        }

        @Override
        public String toRelativeString(PathArgument previous) {
            return this.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AugmentationIdentifier)) {
                return false;
            }
            AugmentationIdentifier that = (AugmentationIdentifier)obj;
            return this.childNames.equals(that.childNames);
        }

        public int hashCode() {
            return this.childNames.hashCode();
        }

        @Override
        public int compareTo(PathArgument o) {
            int otherSize;
            if (!(o instanceof AugmentationIdentifier)) {
                return -1;
            }
            AugmentationIdentifier other = (AugmentationIdentifier)o;
            Set<QName> otherChildNames = other.getPossibleChildNames();
            int thisSize = this.childNames.size();
            if (thisSize == (otherSize = otherChildNames.size())) {
                if (this.childNames.equals(otherChildNames)) {
                    return 0;
                }
                ArrayList diff = new ArrayList(Sets.symmetricDifference(this.childNames, otherChildNames));
                Verify.verify((!diff.isEmpty() ? 1 : 0) != 0, (String)"Augmentation identifiers %s and %s report no difference", (Object)this, (Object)o);
                diff.sort(QName::compareTo);
                return this.childNames.contains(diff.get(0)) ? -1 : 1;
            }
            if (thisSize < otherSize) {
                return 1;
            }
            return -1;
        }

        private Object writeReplace() {
            return new AIv1(this);
        }
    }

    public static final class NodeWithValue<T>
    extends AbstractPathArgument {
        private static final long serialVersionUID = -3637456085341738431L;
        private final T value;

        public NodeWithValue(QName node, T value) {
            super(node);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        protected int hashCodeImpl() {
            int prime = 31;
            int result = super.hashCodeImpl();
            result = 31 * result + YangInstanceIdentifier.hashCode(this.value);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            NodeWithValue other = (NodeWithValue)obj;
            return Objects.deepEquals(this.value, other.value);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.value + "]";
        }

        @Override
        public String toRelativeString(PathArgument previous) {
            return super.toRelativeString(previous) + "[" + this.value + "]";
        }

        @Override
        Object writeReplace() {
            return new NIVv1(this);
        }
    }

    public static abstract class NodeIdentifierWithPredicates
    extends AbstractPathArgument {
        private static final long serialVersionUID = -4787195606494761540L;

        NodeIdentifierWithPredicates(QName node) {
            super(node);
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node) {
            return new Regular(node, (Map<QName, Object>)ImmutableMap.of());
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, QName key, Object value) {
            return new Singleton(node, key, value);
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, Map.Entry<QName, Object> entry) {
            return NodeIdentifierWithPredicates.of(node, entry.getKey(), entry.getValue());
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, Map<QName, Object> keyValues) {
            return keyValues.size() == 1 ? NodeIdentifierWithPredicates.of(keyValues, node) : new Regular(node, ImmutableOffsetMap.unorderedCopyOf(keyValues));
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, ImmutableOffsetMap<QName, Object> keyValues) {
            return keyValues.size() == 1 ? NodeIdentifierWithPredicates.of(keyValues, node) : new Regular(node, (Map<QName, Object>)keyValues);
        }

        @Deprecated
        public static @NonNull NodeIdentifierWithPredicates of(QName node, SharedSingletonMap<QName, Object> keyValues) {
            return NodeIdentifierWithPredicates.of(node, keyValues.getEntry());
        }

        private static @NonNull NodeIdentifierWithPredicates of(Map<QName, Object> keyValues, QName node) {
            return NodeIdentifierWithPredicates.of(node, keyValues.entrySet().iterator().next());
        }

        @Beta
        public abstract @NonNull Set<Map.Entry<QName, Object>> entrySet();

        @Beta
        public abstract @NonNull Set<QName> keySet();

        @Beta
        public abstract boolean containsKey(QName var1);

        @Beta
        public abstract @NonNull Collection<Object> values();

        @Beta
        public final @Nullable Object getValue(QName key) {
            return this.keyValue(Objects.requireNonNull(key));
        }

        @Beta
        public final <T> @Nullable T getValue(QName key, Class<T> valueClass) {
            return valueClass.cast(this.getValue(key));
        }

        @Beta
        public abstract int size();

        @Deprecated
        @Beta
        public abstract @NonNull Map<QName, Object> asMap();

        @Override
        protected final int hashCodeImpl() {
            int result = 31 * super.hashCodeImpl();
            for (Map.Entry<QName, Object> entry : this.entrySet()) {
                result += entry.getKey().hashCode() + YangInstanceIdentifier.hashCode(entry.getValue());
            }
            return result;
        }

        @Override
        public final boolean equals(Object obj) {
            return super.equals(obj) && this.equalMapping((NodeIdentifierWithPredicates)obj);
        }

        abstract boolean equalMapping(NodeIdentifierWithPredicates var1);

        abstract @Nullable Object keyValue(@NonNull QName var1);

        @Override
        public final String toString() {
            return super.toString() + "[" + this.asMap() + "]";
        }

        @Override
        public final String toRelativeString(PathArgument previous) {
            return super.toRelativeString(previous) + "[" + this.asMap() + "]";
        }

        @Override
        final Object writeReplace() {
            return new NIPv2(this);
        }

        private static final class Regular
        extends NodeIdentifierWithPredicates {
            private static final long serialVersionUID = 1L;
            private final @NonNull Map<QName, Object> keyValues;

            Regular(QName node, Map<QName, Object> keyValues) {
                super(node);
                this.keyValues = Objects.requireNonNull(keyValues);
            }

            @Override
            public Set<Map.Entry<QName, Object>> entrySet() {
                return this.keyValues.entrySet();
            }

            @Override
            public Set<QName> keySet() {
                return this.keyValues.keySet();
            }

            @Override
            public boolean containsKey(QName qname) {
                return this.keyValues.containsKey(Objects.requireNonNull(qname));
            }

            @Override
            public Collection<Object> values() {
                return this.keyValues.values();
            }

            @Override
            public int size() {
                return this.keyValues.size();
            }

            @Override
            public Map<QName, Object> asMap() {
                return this.keyValues;
            }

            @Override
            Object keyValue(QName qname) {
                return this.keyValues.get(qname);
            }

            @Override
            boolean equalMapping(NodeIdentifierWithPredicates other) {
                Map<QName, Object> otherKeyValues = ((Regular)other).keyValues;
                if (this.keyValues == otherKeyValues) {
                    return true;
                }
                if (this.keyValues.size() != otherKeyValues.size()) {
                    return false;
                }
                for (Map.Entry<QName, Object> entry : this.entrySet()) {
                    Object otherValue = otherKeyValues.get(entry.getKey());
                    if (otherValue != null && Objects.deepEquals(entry.getValue(), otherValue)) continue;
                    return false;
                }
                return true;
            }
        }

        @Beta
        public static final class Singleton
        extends NodeIdentifierWithPredicates {
            private static final long serialVersionUID = 1L;
            private final @NonNull QName key;
            private final @NonNull Object value;

            Singleton(QName node, QName key, Object value) {
                super(node);
                this.key = Objects.requireNonNull(key);
                this.value = Objects.requireNonNull(value);
            }

            public SingletonSet<Map.Entry<QName, Object>> entrySet() {
                return SingletonSet.of(this.singleEntry());
            }

            public SingletonSet<QName> keySet() {
                return SingletonSet.of((Object)this.key);
            }

            @Override
            public boolean containsKey(QName qname) {
                return this.key.equals((Object)Objects.requireNonNull(qname));
            }

            public SingletonSet<Object> values() {
                return SingletonSet.of((Object)this.value);
            }

            @Override
            public int size() {
                return 1;
            }

            public ImmutableMap<QName, Object> asMap() {
                return ImmutableMap.of((Object)this.key, (Object)this.value);
            }

            public @NonNull Map.Entry<QName, Object> singleEntry() {
                return new AbstractMap.SimpleImmutableEntry<QName, Object>(this.key, this.value);
            }

            @Override
            boolean equalMapping(NodeIdentifierWithPredicates other) {
                Singleton single = (Singleton)other;
                return this.key.equals((Object)single.key) && Objects.deepEquals(this.value, single.value);
            }

            @Override
            Object keyValue(QName qname) {
                return this.key.equals((Object)qname) ? this.value : null;
            }
        }
    }

    public static final class NodeIdentifier
    extends AbstractPathArgument {
        private static final long serialVersionUID = -2255888212390871347L;
        private static final LoadingCache<QName, NodeIdentifier> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QName, NodeIdentifier>(){

            public NodeIdentifier load(QName key) {
                return new NodeIdentifier(key);
            }
        });

        public NodeIdentifier(QName node) {
            super(node);
        }

        public static @NonNull NodeIdentifier create(QName node) {
            return (NodeIdentifier)CACHE.getUnchecked((Object)node);
        }

        @Override
        Object writeReplace() {
            return new NIv1(this);
        }
    }

    private static abstract class AbstractPathArgument
    implements PathArgument {
        private static final long serialVersionUID = -4546547994250849340L;
        private final @NonNull QName nodeType;
        private volatile transient int hashValue;

        protected AbstractPathArgument(QName nodeType) {
            this.nodeType = Objects.requireNonNull(nodeType);
        }

        @Override
        public final QName getNodeType() {
            return this.nodeType;
        }

        @Override
        public int compareTo(PathArgument o) {
            return this.nodeType.compareTo(o.getNodeType());
        }

        protected int hashCodeImpl() {
            return 31 + this.getNodeType().hashCode();
        }

        public final int hashCode() {
            int local = this.hashValue;
            return local != 0 ? local : (this.hashValue = this.hashCodeImpl());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.getNodeType().equals((Object)((AbstractPathArgument)obj).getNodeType());
        }

        public String toString() {
            return this.getNodeType().toString();
        }

        @Override
        public String toRelativeString(PathArgument previous) {
            if (previous instanceof AbstractPathArgument) {
                QNameModule mod = previous.getNodeType().getModule();
                if (this.getNodeType().getModule().equals((Object)mod)) {
                    return this.getNodeType().getLocalName();
                }
            }
            return this.getNodeType().toString();
        }

        abstract Object writeReplace();
    }

    public static interface PathArgument
    extends Comparable<PathArgument>,
    Immutable,
    Serializable {
        public @NonNull QName getNodeType();

        public @NonNull String toRelativeString(PathArgument var1);
    }
}

