/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DuplicateEntry;
import org.opendaylight.yangtools.yang.data.api.schema.DuplicateFinder;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Beta
public final class NormalizedNodes {
    private static final int STRINGTREE_INDENT = 4;

    private NormalizedNodes() {
    }

    public static Map<NormalizedNode<?, ?>, DuplicateEntry> findDuplicates(@NonNull NormalizedNode<?, ?> node) {
        return Maps.filterValues(DuplicateFinder.findDuplicates(node), input -> !input.getDuplicates().isEmpty());
    }

    public static Optional<NormalizedNode<?, ?>> findNode(YangInstanceIdentifier rootPath, NormalizedNode<?, ?> rootNode, YangInstanceIdentifier childPath) {
        Optional<YangInstanceIdentifier> relativePath = childPath.relativeTo(rootPath);
        return relativePath.isPresent() ? NormalizedNodes.findNode(rootNode, relativePath.get()) : Optional.empty();
    }

    public static Optional<NormalizedNode<?, ?>> findNode(Optional<NormalizedNode<?, ?>> parent, Iterable<YangInstanceIdentifier.PathArgument> relativePath) {
        Iterator<YangInstanceIdentifier.PathArgument> pathIterator = Objects.requireNonNull(relativePath, "Relative path must not be null").iterator();
        Optional<NormalizedNode<?, ?>> currentNode = Objects.requireNonNull(parent, "Parent must not be null");
        while (currentNode.isPresent() && pathIterator.hasNext()) {
            currentNode = NormalizedNodes.getDirectChild(currentNode.get(), pathIterator.next());
        }
        return currentNode;
    }

    public static Optional<NormalizedNode<?, ?>> findNode(Optional<NormalizedNode<?, ?>> parent, YangInstanceIdentifier.PathArgument ... relativePath) {
        return NormalizedNodes.findNode(parent, Arrays.asList(relativePath));
    }

    public static Optional<NormalizedNode<?, ?>> findNode(NormalizedNode<?, ?> parent, Iterable<YangInstanceIdentifier.PathArgument> relativePath) {
        return NormalizedNodes.findNode(Optional.ofNullable(parent), relativePath);
    }

    public static Optional<NormalizedNode<?, ?>> findNode(NormalizedNode<?, ?> parent, SchemaPath relativePath) {
        Preconditions.checkArgument((!relativePath.isAbsolute() ? 1 : 0) != 0, (String)"%s is not a relative path", (Object)relativePath);
        return NormalizedNodes.findNode(Optional.ofNullable(parent), (Iterable<YangInstanceIdentifier.PathArgument>)Iterables.transform((Iterable)relativePath.getPathFromRoot(), YangInstanceIdentifier.NodeIdentifier::new));
    }

    public static Optional<NormalizedNode<?, ?>> findNode(NormalizedNode<?, ?> parent, YangInstanceIdentifier.PathArgument ... relativePath) {
        return NormalizedNodes.findNode(parent, Arrays.asList(relativePath));
    }

    public static Optional<NormalizedNode<?, ?>> findNode(NormalizedNode<?, ?> tree, YangInstanceIdentifier path) {
        return NormalizedNodes.findNode(Optional.of(Objects.requireNonNull(tree, "Tree must not be null")), Objects.requireNonNull(path, "Path must not be null").getPathArguments());
    }

    public static Optional<NormalizedNode<?, ?>> getDirectChild(NormalizedNode<?, ?> node, YangInstanceIdentifier.PathArgument pathArg) {
        if (node instanceof ValueNode) {
            return Optional.empty();
        }
        if (node instanceof DataContainerNode) {
            return ((DataContainerNode)node).getChild(pathArg);
        }
        if (node instanceof MapNode && pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return ((MapNode)node).getChild((YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg);
        }
        if (node instanceof LeafSetNode && pathArg instanceof YangInstanceIdentifier.NodeWithValue) {
            return ((LeafSetNode)node).getChild((YangInstanceIdentifier.NodeWithValue)pathArg);
        }
        return Optional.empty();
    }

    public static String toStringTree(NormalizedNode<?, ?> node) {
        StringBuilder builder = new StringBuilder();
        NormalizedNodes.toStringTree(builder, node, 0);
        return builder.toString();
    }

    private static void toStringTree(StringBuilder builder, NormalizedNode<?, ?> node, int offset) {
        String prefix = Strings.repeat((String)" ", (int)offset);
        builder.append(prefix).append(NormalizedNodes.toStringTree((YangInstanceIdentifier.PathArgument)node.getIdentifier()));
        if (node instanceof NormalizedNodeContainer) {
            NormalizedNodeContainer container = (NormalizedNodeContainer)node;
            builder.append(" {\n");
            Iterator iterator = container.getValue().iterator();
            while (iterator.hasNext()) {
                NormalizedNode child = (NormalizedNode)iterator.next();
                NormalizedNodes.toStringTree(builder, child, offset + 4);
            }
            builder.append(prefix).append('}');
        } else {
            builder.append(' ').append(node.getValue());
        }
        builder.append('\n');
    }

    private static String toStringTree(YangInstanceIdentifier.PathArgument identifier) {
        if (identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return identifier.getNodeType().getLocalName() + ((YangInstanceIdentifier.NodeIdentifierWithPredicates)identifier).values();
        }
        if (identifier instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return "augmentation";
        }
        return identifier.getNodeType().getLocalName();
    }
}

