/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

final class NormalizedNodeDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final NormalizedNode<?, ?> data;

    NormalizedNodeDataTreeCandidateNode(@NonNull NormalizedNode<?, ?> data) {
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.data.getIdentifier();
    }

    @Override
    public Collection<DataTreeCandidateNode> getChildNodes() {
        if (this.data instanceof NormalizedNodeContainer) {
            return Collections2.transform((Collection)((NormalizedNodeContainer)this.data).getValue(), input -> input == null ? null : new NormalizedNodeDataTreeCandidateNode((NormalizedNode<?, ?>)input));
        }
        return ImmutableList.of();
    }

    @Override
    public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        if (this.data instanceof NormalizedNodeContainer) {
            Optional child = ((NormalizedNodeContainer)this.data).getChild(childIdentifier);
            return child.map(input -> new NormalizedNodeDataTreeCandidateNode((NormalizedNode<?, ?>)input)).orElse(null);
        }
        return null;
    }

    @Override
    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataAfter() {
        return Optional.of(this.data);
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataBefore() {
        return Optional.empty();
    }
}

