/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.objcache;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.yangtools.objcache.ObjectCache;
import org.opendaylight.yangtools.objcache.impl.StaticObjectCacheBinder;
import org.opendaylight.yangtools.objcache.spi.IObjectCacheFactory;
import org.opendaylight.yangtools.objcache.spi.NoopObjectCacheBinder;

public final class ObjectCacheFactory {
    private static volatile IObjectCacheFactory factory;

    @GuardedBy(value="this")
    private static synchronized IObjectCacheFactory initialize() {
        IObjectCacheFactory f = factory;
        if (f != null) {
            return f;
        }
        try {
            factory = f = StaticObjectCacheBinder.getInstance().getProductCacheFactory();
        }
        catch (NoClassDefFoundError e) {
            f = NoopObjectCacheBinder.INSTANCE.getProductCacheFactory();
        }
        return f;
    }

    public static synchronized void reset() {
        factory = null;
    }

    public static ObjectCache getObjectCache(@Nonnull Class<?> objClass) {
        IObjectCacheFactory f = factory;
        if (f == null) {
            f = ObjectCacheFactory.initialize();
        }
        return f.getObjectCache((Class)Preconditions.checkNotNull(objClass));
    }
}

