/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.sdninterfaceapp.impl.OpendaylightSdniQosMsgServiceImpl;
import org.opendaylight.sdninterfaceapp.impl.database.SdniDataBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.OpendaylightSdniQosMsgService;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QosDataServiceProvider
implements BindingAwareProvider,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(QosDataServiceProvider.class);
    private BindingAwareBroker.RpcRegistration<OpendaylightSdniQosMsgService> qosDataServiceRpcReg;
    private final DataBroker dataBroker;

    public QosDataServiceProvider(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
    }

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        this.logger.info("Provider Session initialized");
        OpendaylightSdniQosMsgServiceImpl opendaylightSdniQosMsgService = OpendaylightSdniQosMsgServiceImpl.getInstance();
        opendaylightSdniQosMsgService.setDataBroker(this.dataBroker);
        this.qosDataServiceRpcReg = session.addRpcImplementation(OpendaylightSdniQosMsgService.class, (RpcService)opendaylightSdniQosMsgService);
        SdniDataBase sdb = SdniDataBase.getInstance();
        sdb.create_trusted_controllers();
    }

    @Override
    public void close() throws Exception {
        this.logger.info("QosDataService Closed");
        if (this.qosDataServiceRpcReg != null) {
            this.qosDataServiceRpcReg.close();
        }
    }
}

