/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.xml;

import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.odlparent.logging.markers.Markers;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtil.class);
    private static final Templates PRETTY_PRINT_TEMPLATE;
    private static final DocumentBuilderFactory BUILDER_FACTORY;
    private static final ThreadLocal<DocumentBuilder> DEFAULT_DOM_BUILDER;

    private XmlUtil() {
    }

    public static boolean hasNamespace(Element element) {
        return XmlUtil.namespaceAttribute(element) != null || XmlUtil.namespace(element) != null;
    }

    public static @Nullable String namespace(Element element) {
        String namespaceURI = element.getNamespaceURI();
        return namespaceURI == null || namespaceURI.isEmpty() ? null : namespaceURI;
    }

    public static @NonNull Element requireSingleElement(Element element, String namespace, String localName) throws DocumentedException {
        if (namespace.equals("*")) {
            throw new IllegalArgumentException("Unsupported wildcard namespace");
        }
        if (localName.equals("*")) {
            throw new IllegalArgumentException("Unsupported wildcard localName");
        }
        NodeList elements = element.getElementsByTagNameNS(namespace, localName);
        Element first = (Element)elements.item(0);
        if (first == null) {
            if (LOG.isDebugEnabled(Markers.confidential())) {
                LOG.debug(Markers.confidential(), "{}:{} not present in {}", new Object[]{namespace, localName, XmlUtil.toString(element)});
            }
            throw new DocumentedException("Expected %s:%s once, not found".formatted(namespace, localName), ErrorType.APPLICATION, ErrorTag.MISSING_ELEMENT, ErrorSeverity.ERROR, Map.of("bad-element", localName));
        }
        Element second = (Element)elements.item(1);
        if (second != null) {
            if (LOG.isDebugEnabled(Markers.confidential())) {
                LOG.debug(Markers.confidential(), "{}:{} is present multiple times in {}", new Object[]{namespace, localName, XmlUtil.toString(element)});
            }
            throw new DocumentedException("Expected %s:%s once, found at least twice".formatted(namespace, localName), ErrorType.APPLICATION, ErrorTag.UNKNOWN_ELEMENT, ErrorSeverity.ERROR, Map.of("bad-element", localName));
        }
        return first;
    }

    static @Nullable String namespaceAttribute(Element element) {
        String attribute = element.getAttribute("xmlns");
        return attribute.isEmpty() ? null : attribute;
    }

    public static Element readXmlToElement(File xmlFile) throws SAXException, IOException {
        return XmlUtil.readXmlToDocument(new FileInputStream(xmlFile)).getDocumentElement();
    }

    public static Element readXmlToElement(String xmlContent) throws SAXException, IOException {
        Document doc = XmlUtil.readXmlToDocument(xmlContent);
        return doc.getDocumentElement();
    }

    public static Element readXmlToElement(InputStream xmlContent) throws SAXException, IOException {
        Document doc = XmlUtil.readXmlToDocument(xmlContent);
        return doc.getDocumentElement();
    }

    public static Document readXmlToDocument(String xmlContent) throws SAXException, IOException {
        return XmlUtil.readXmlToDocument(new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)));
    }

    public static Document readXmlToDocument(InputStream xmlContent) throws SAXException, IOException {
        Document doc = DEFAULT_DOM_BUILDER.get().parse(xmlContent);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static Document newDocument() {
        return DEFAULT_DOM_BUILDER.get().newDocument();
    }

    public static Transformer newIndentingTransformer() throws TransformerConfigurationException {
        Transformer ret = PRETTY_PRINT_TEMPLATE.newTransformer();
        ret.setOutputProperty("indent", "yes");
        return ret;
    }

    public static String toString(Document document) {
        return XmlUtil.toString(document.getDocumentElement());
    }

    public static String toString(Element xml) {
        return XmlUtil.toString(xml, false);
    }

    public static String toString(XmlElement xmlElement) {
        return XmlUtil.toString(xmlElement.getDomElement(), false);
    }

    public static String toString(Element xml, boolean addXmlDeclaration) {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = XmlUtil.newIndentingTransformer();
            transformer.setOutputProperty("omit-xml-declaration", addXmlDeclaration ? "no" : "yes");
            transformer.transform(new DOMSource(xml), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unable to serialize xml element " + xml, e);
        }
        return writer.toString();
    }

    public static String toString(Document doc, boolean addXmlDeclaration) {
        return XmlUtil.toString(doc.getDocumentElement(), addXmlDeclaration);
    }

    public static Document createDocumentCopy(Document original) {
        Document copiedDocument = XmlUtil.newDocument();
        Node copiedRoot = copiedDocument.importNode(original.getDocumentElement(), true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    static {
        try {
            PRETTY_PRINT_TEMPLATE = TransformerFactory.newInstance().newTemplates(new StreamSource(Resources.getResource(XmlUtil.class, (String)"/pretty-print.xsl").openStream()));
        }
        catch (IOException | TransformerConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        BUILDER_FACTORY = factory;
        DEFAULT_DOM_BUILDER = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    return BUILDER_FACTORY.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new IllegalStateException("Failed to create threadLocal dom builder", e);
                }
            }

            @Override
            public void set(DocumentBuilder value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

