/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RpcReplyMessage
extends NetconfMessage {
    public static final @NonNull String ELEMENT_NAME = "rpc-reply";

    RpcReplyMessage(Document document) {
        super(document);
    }

    public static @NonNull RpcReplyMessage of(Document document) throws DocumentedException {
        Element root = document.getDocumentElement();
        String rootName = root.getLocalName();
        if (!ELEMENT_NAME.equals(rootName)) {
            throw new DocumentedException("Unexpected element name " + rootName, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_ELEMENT, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of((Object)"bad-element", (Object)rootName));
        }
        String rootNs = root.getNamespaceURI();
        if (!"urn:ietf:params:xml:ns:netconf:base:1.0".equals(rootNs)) {
            throw new DocumentedException("Unexpected element namespace " + rootNs, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of((Object)"bad-element", (Object)rootName, (Object)"bad-namespace", (Object)rootNs));
        }
        return new RpcReplyMessage(document);
    }

    public static @NonNull RpcReplyMessage of(DocumentedException ex) {
        return new RpcReplyMessage(ex.toXMLDocument());
    }

    public static @NonNull RpcReplyMessage ofOperation(String messageId, Document document) {
        Element rpcElem = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", ELEMENT_NAME);
        rpcElem.appendChild(document.getDocumentElement());
        rpcElem.setAttribute("message-id", Objects.requireNonNull(messageId));
        document.appendChild(rpcElem);
        return new RpcReplyMessage(document);
    }

    public @Nullable String messageId() {
        Attr attr = this.getDocument().getDocumentElement().getAttributeNode("message-id");
        return attr == null ? null : attr.getValue();
    }
}

