/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.api.messages.RpcMessage;
import org.opendaylight.netconf.api.messages.RpcReplyMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetconfMessage {
    private final @NonNull Document document;

    public NetconfMessage(Document document) {
        this.document = Objects.requireNonNull(document);
    }

    public static @NonNull NetconfMessage of(Document document) throws DocumentedException {
        Element root = document.getDocumentElement();
        String rootName = root.getLocalName();
        String rootNs = root.getNamespaceURI();
        if (rootNs != null) {
            switch (rootNs) {
                case "urn:ietf:params:xml:ns:netconf:base:1.0": {
                    switch (rootName) {
                        case "hello": {
                            return new HelloMessage(document);
                        }
                        case "rpc": {
                            return RpcMessage.ofChecked(document);
                        }
                        case "rpc-reply": {
                            return new RpcReplyMessage(document);
                        }
                    }
                    break;
                }
                case "urn:ietf:params:xml:ns:netconf:notification:1.0": {
                    switch (rootName) {
                        case "notification": {
                            return NotificationMessage.ofChecked(document);
                        }
                    }
                    break;
                }
                default: {
                    throw new DocumentedException("Unhandled namespace " + rootNs, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR, Map.of("bad-element", rootName));
                }
            }
        } else if ("hello".equals(rootName)) {
            return new HelloMessage(document);
        }
        throw new DocumentedException("Unknown element " + rootName, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_ELEMENT, ErrorSeverity.ERROR, Map.of("bad-element", rootName));
    }

    public final @NonNull Document getDocument() {
        return this.document;
    }

    public final String toString() {
        return XmlUtil.toString(this.document);
    }
}

