/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.ready.karaf.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.infrautils.ready.karaf.internal.ProxyUtil;
import org.opendaylight.infrautils.ready.order.FunctionalityReady;
import org.opendaylight.infrautils.ready.order.FunctionalityReadyNotifier;
import org.opendaylight.infrautils.ready.order.FunctionalityReadyRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class FunctionalityReadyNotifierImpl
implements FunctionalityReadyNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionalityReadyNotifierImpl.class);
    private @Nullable BundleContext bundleContext = null;

    public synchronized <T extends FunctionalityReady> FunctionalityReadyRegistration<T> register(Class<T> markerInterface) {
        Objects.requireNonNull(markerInterface, "markerInterface == null");
        Preconditions.checkArgument((boolean)markerInterface.isInterface(), (Object)"markerInterface is not an interface (cannot be a class");
        try {
            if (this.bundleContext.getAllServiceReferences(markerInterface.getName(), null).length > 0) {
                throw new IllegalStateException("Already a FunctionalityReady registration for: " + markerInterface);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("InvalidSyntaxException should never happen for 'null' filter?!", e);
        }
        T uselessInstance = ProxyUtil.newInstance(markerInterface);
        ServiceRegistration registration = this.bundleContext.registerService(markerInterface, uselessInstance, null);
        LOG.info("FunctionalityReady now registered as (pseudo) OSGi service: {}", (Object)markerInterface.getName());
        return () -> {
            try {
                registration.unregister();
            }
            catch (IllegalStateException e) {
                LOG.debug("org.osgi.framework.ServiceRegistration.unregister() failed", (Throwable)e);
            }
        };
    }

    @Activate
    synchronized void activate(BundleContext newBundleContext) {
        this.bundleContext = newBundleContext;
    }
}

