/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.directives;

import com.google.common.base.Preconditions;
import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Header;

public class HeaderDirective
implements TemplateDirectiveModel {
    private static final String GENERATOR_CLASS = JMXGenerator.class.getCanonicalName();
    private static final String OBJECT = "header";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Object object = params.get(OBJECT);
        Header header = null;
        if (object != null) {
            object = ((StringModel)object).getWrappedObject();
            Preconditions.checkArgument((boolean)(object instanceof Header), (Object)("Template header should be instance of " + Header.class + " but was " + object.getClass()));
            header = (Header)object;
        }
        Writer out = env.getOut();
        StringBuilder build = new StringBuilder();
        build.append("/**");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated file");
        build.append(System.lineSeparator());
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated from: ");
        build.append(header != null ? header.toString() : "");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated by: " + GENERATOR_CLASS);
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Generated at: " + new Date());
        build.append(System.lineSeparator());
        build.append("* ");
        build.append(System.lineSeparator());
        build.append("* ");
        build.append("Do not modify this file unless it is present under src/main directory ");
        build.append(System.lineSeparator());
        build.append("*/");
        build.append(System.lineSeparator());
        out.write(build.toString().toCharArray());
    }
}

