/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api;

import java.util.Arrays;
import java.util.List;
import org.opendaylight.controller.config.api.JmxAttribute;

public class JmxAttributeValidationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<JmxAttribute> attributeNames;

    public JmxAttributeValidationException(JmxAttribute jmxAttribute) {
        this(Arrays.asList(jmxAttribute));
    }

    public JmxAttributeValidationException(List<JmxAttribute> jmxAttribute) {
        this.attributeNames = jmxAttribute;
    }

    public JmxAttributeValidationException(String message, JmxAttribute jmxAttribute) {
        this(message, Arrays.asList(jmxAttribute));
    }

    public JmxAttributeValidationException(String message, List<JmxAttribute> jmxAttributes) {
        super(message);
        this.attributeNames = jmxAttributes;
    }

    public JmxAttributeValidationException(String message, Throwable cause, JmxAttribute jmxAttribute) {
        this(message, cause, Arrays.asList(jmxAttribute));
    }

    public JmxAttributeValidationException(String message, Throwable cause, List<JmxAttribute> jmxAttributes) {
        super(message, cause);
        this.attributeNames = jmxAttributes;
    }

    public List<JmxAttribute> getAttributeNames() {
        return this.attributeNames;
    }

    public static <T> T checkNotNull(T param, JmxAttribute jmxAttribute) {
        String message = "is null";
        return JmxAttributeValidationException.checkNotNull(param, message, jmxAttribute);
    }

    public static <T> T checkNotNull(T param, String message, JmxAttribute jmxAttribute) {
        if (param == null) {
            throw new JmxAttributeValidationException(jmxAttribute.getAttributeName() + " " + message, jmxAttribute);
        }
        return param;
    }

    public static JmxAttributeValidationException wrap(Throwable throwable, JmxAttribute jmxAttribute) throws JmxAttributeValidationException {
        return JmxAttributeValidationException.wrap(throwable, throwable.getMessage(), jmxAttribute);
    }

    public static JmxAttributeValidationException wrap(Throwable throwable, String message, JmxAttribute jmxAttribute) {
        throw new JmxAttributeValidationException(jmxAttribute.getAttributeName() + " " + message, throwable, jmxAttribute);
    }

    public static void checkCondition(boolean condition, String message, JmxAttribute jmxAttribute) throws JmxAttributeValidationException {
        if (!condition) {
            throw new JmxAttributeValidationException(jmxAttribute.getAttributeName() + " " + message, jmxAttribute);
        }
    }
}

