/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bier.test.driver;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.opendaylight.bier.adapter.api.BierConfigReader;
import org.opendaylight.bier.adapter.api.BierConfigWriter;
import org.opendaylight.bier.adapter.api.BierTeBiftWriter;
import org.opendaylight.bier.adapter.api.BierTeBitstringWriter;
import org.opendaylight.bier.adapter.api.BierTeLabelRangeConfigWriter;
import org.opendaylight.bier.adapter.api.ChannelConfigReader;
import org.opendaylight.bier.adapter.api.ChannelConfigWriter;
import org.opendaylight.bier.adapter.api.ConfigurationResult;
import org.opendaylight.bier.adapter.api.ConfigurationType;
import org.opendaylight.bier.driver.common.util.DataGetter;
import org.opendaylight.bier.driver.common.util.IidConstants;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.ChannelBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.ChannelKey;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNode;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.EgressNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.egress.node.RcvTp;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.bier.network.channel.bier.channel.channel.egress.node.RcvTpBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.DomainId;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.configure.result.ConfigureResult;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.configure.result.ConfigureResultBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.te.path.rev170503.TePath;
import org.opendaylight.yang.gen.v1.urn.bier.te.path.rev170503.bier.te.path.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckBierGlobalInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckBierGlobalOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckBierGlobalOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.CheckChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ReadBierGlobalInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ReadBierGlobalOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ReadBierGlobalOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetBierTeBitstringInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetBierTeBitstringOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetBierTeBitstringOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetChannelOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetChannelOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetDomainConfigInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetDomainConfigOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetDomainConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetEgressNodeInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetEgressNodeOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetEgressNodeOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetIpv4ConfigInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetIpv4ConfigOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetIpv4ConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetLabelRangeInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetLabelRangeOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetLabelRangeOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetSubdomainConfigInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetSubdomainConfigOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetSubdomainConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetTeBiftInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetTeBiftOutput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetTeBiftOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.TestDriverService;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.BierTeLabelRangeSize;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.bier.topology.BierNode;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.network.topology.bier.topology.BierNodeKey;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.BierTeLableRangeBuilder;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.params.Domain;
import org.opendaylight.yang.gen.v1.urn.bier.topology.rev161102.bier.node.params.DomainBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.BierGlobal;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.BierGlobalBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.bier.global.SubDomain;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.global.cfg.bier.global.SubDomainBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.subdomain.Af;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.subdomain.AfBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.subdomain.af.Ipv4;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.bier.subdomain.af.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.te.rev161013.TeInfo;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.te.rev161013.routing.BierTeConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.mpls.rev160705.MplsLabel;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDriverProvider
implements TestDriverService {
    private static final Logger LOG = LoggerFactory.getLogger(TestDriverProvider.class);
    private BierConfigWriter bierConfigWriter;
    private BierConfigReader bierConfigReader;
    private RpcProviderRegistry rpcRegistry;
    private final DataBroker dataBroker;
    private BindingAwareBroker.RpcRegistration<TestDriverService> rpcReg;
    private ChannelConfigWriter channelConfigWrite;
    private ChannelConfigReader channelConfigReader;
    private BierTeBiftWriter bierTeBiftWriter;
    private BierTeLabelRangeConfigWriter bierTeLabelRangeConfigWriter;
    private BierTeBitstringWriter bierTeBitstringWriter;

    public TestDriverProvider(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
    }

    public void setBierConfigWriter(BierConfigWriter bierConfigWriter) {
        this.bierConfigWriter = bierConfigWriter;
    }

    public void setBierConfigReader(BierConfigReader bierConfigReader) {
        this.bierConfigReader = bierConfigReader;
    }

    public void setRpcRegistry(RpcProviderRegistry rpcRegistry) {
        this.rpcRegistry = rpcRegistry;
    }

    public void setChannelConfigWriter(ChannelConfigWriter channelConfigWriter) {
        this.channelConfigWrite = channelConfigWriter;
    }

    public void setChannelConfigReader(ChannelConfigReader channelConfigReader) {
        this.channelConfigReader = channelConfigReader;
    }

    public void setBierTeLabelRangeConfigWriter(BierTeLabelRangeConfigWriter bierTeLabelRangeConfigWriter) {
        this.bierTeLabelRangeConfigWriter = bierTeLabelRangeConfigWriter;
    }

    public void setBierTeBiftWriter(BierTeBiftWriter bierTeBiftWriter) {
        this.bierTeBiftWriter = bierTeBiftWriter;
    }

    public void setBierTeBitstringWriter(BierTeBitstringWriter bierTeBitstringWriter) {
        this.bierTeBitstringWriter = bierTeBitstringWriter;
    }

    public void init() {
        LOG.info("Session Initiated");
        this.rpcReg = this.rpcRegistry.addRpcImplementation(TestDriverService.class, (RpcService)this);
    }

    public void close() {
        LOG.info(" Closed");
        this.rpcReg.close();
    }

    public ConfigurationType getConfigurationType(ConfigType type) {
        switch (type) {
            case ADD: {
                return ConfigurationType.ADD;
            }
            case MODIFY: {
                return ConfigurationType.MODIFY;
            }
            case DELETE: {
                return ConfigurationType.DELETE;
            }
        }
        return null;
    }

    public ConfigureResult buildResult(ConfigurationResult result) {
        if (result.isSuccessful()) {
            return new ConfigureResultBuilder().setResult(ConfigureResult.Result.SUCCESS).build();
        }
        return new ConfigureResultBuilder().setResult(ConfigureResult.Result.FAILURE).setErrorCause(result.getFailureReason()).build();
    }

    public Future<RpcResult<SetDomainConfigOutput>> setDomainConfig(SetDomainConfigInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.bierConfigWriter.writeDomain(type, input.getNodeName(), new DomainBuilder().setBierGlobal(input.getBierGlobal()).build());
        SetDomainConfigOutput output = new SetDomainConfigOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetSubdomainConfigOutput>> setSubdomainConfig(SetSubdomainConfigInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        SubDomain subDomain = new SubDomainBuilder().setSubDomainId(input.getSubDomainId()).setAf(input.getAf()).setBfrId(input.getBfrId()).setBitstringlength(input.getBitstringlength()).setIgpType(input.getIgpType()).setMtId(input.getMtId()).build();
        ConfigurationResult result = this.bierConfigWriter.writeSubdomain(type, input.getNodeName(), new DomainId(input.getDomainId()), subDomain);
        SetSubdomainConfigOutput output = new SetSubdomainConfigOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetIpv4ConfigOutput>> setIpv4Config(SetIpv4ConfigInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        Ipv4 ipv4 = new Ipv4Builder().setBitstringlength(input.getBitstringlength()).setBierMplsLabelBase(input.getBierMplsLabelBase()).setBierMplsLabelRangeSize(input.getBierMplsLabelRangeSize()).build();
        ConfigurationResult result = this.bierConfigWriter.writeSubdomainIpv4(type, input.getNodeName(), new DomainId(input.getDomainId()), new SubDomainId(input.getSubDomainId()), ipv4);
        SetIpv4ConfigOutput output = new SetIpv4ConfigOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<ReadBierGlobalOutput>> readBierGlobal(ReadBierGlobalInput input) {
        BierGlobal bierGlobal = this.bierConfigReader.readBierGlobal(input.getNodeName());
        LOG.info("readBierGlobal {}", (Object)bierGlobal);
        ReadBierGlobalOutputBuilder outputBuilder = new ReadBierGlobalOutputBuilder().setBierGlobal(bierGlobal);
        return RpcResultBuilder.success((Object)outputBuilder.build()).buildFuture();
    }

    public SubDomain bulid(SubDomain subDomain) {
        if (subDomain.getAf() == null) {
            return null;
        }
        List ipv4List = subDomain.getAf().getIpv4();
        ArrayList<Ipv4> ipv4ArrayList = new ArrayList<Ipv4>();
        if (ipv4List != null && !ipv4List.isEmpty()) {
            for (Ipv4 ipv4 : ipv4List) {
                ipv4ArrayList.add(new Ipv4Builder(ipv4).build());
            }
        }
        return new SubDomainBuilder().setAf(new AfBuilder().setIpv4(ipv4ArrayList).build()).setBitstringlength(subDomain.getBitstringlength()).setIgpType(subDomain.getIgpType()).setBfrId(subDomain.getBfrId()).setMtId(subDomain.getMtId()).setSubDomainId(subDomain.getSubDomainId()).build();
    }

    public BierGlobal bulid(BierGlobal bierGlobal) {
        List subDomainList = bierGlobal.getSubDomain();
        ArrayList<SubDomain> subDomainArrayList = new ArrayList<SubDomain>();
        if (subDomainList != null && !subDomainList.isEmpty()) {
            for (SubDomain subDomain : subDomainList) {
                subDomainArrayList.add(this.bulid(subDomain));
            }
        }
        return new BierGlobalBuilder().setIpv4BfrPrefix(bierGlobal.getIpv4BfrPrefix()).setSubDomain(subDomainArrayList).setBfrId(bierGlobal.getBfrId()).setBitstringlength(bierGlobal.getBitstringlength()).setEncapsulationType(bierGlobal.getEncapsulationType()).build();
    }

    public BierGlobal readBierGlobalFromController(String nodeId) {
        KeyedInstanceIdentifier bierNodeIId = IidConstants.BIER_TOPO_IID.child(BierNode.class, (Identifier)new BierNodeKey(nodeId));
        BierNode bierNode = (BierNode)DataGetter.readData((DataBroker)this.dataBroker, (InstanceIdentifier)bierNodeIId, (LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION);
        if (bierNode != null && bierNode.getBierNodeParams() != null) {
            List domainList = bierNode.getBierNodeParams().getDomain();
            if (domainList == null || domainList.isEmpty()) {
                LOG.info("readBierGlobalFromController domainList is null");
                return null;
            }
            Iterator iterator = domainList.iterator();
            if (iterator.hasNext()) {
                Domain domain = (Domain)iterator.next();
                LOG.info("readBierGlobalFromController {} {}", (Object)domain.getBierGlobal(), (Object)nodeId);
                return domain.getBierGlobal();
            }
        }
        return null;
    }

    static String buildDetailInfo(Object controller, Object device) {
        String controllerString = String.valueOf(controller);
        String deviceString = String.valueOf(device);
        return "\ncontroller: \n" + controllerString + "\n device : \n" + deviceString + "\n";
    }

    public boolean compareIpv4(SubDomainId subDomainId, List<Ipv4> ipv4FromController, List<Ipv4> ipv4FromDevice, ConfigureResultBuilder resultBuilder) {
        if (ipv4FromController == ipv4FromDevice) {
            return true;
        }
        if (ipv4FromController == null) {
            resultBuilder.setErrorCause(subDomainId.toString() + " Ipv4 from controller is null while it is not null in device. ");
            return false;
        }
        if (ipv4FromDevice == null) {
            resultBuilder.setErrorCause(subDomainId.toString() + " Ipv4 from device is null while it is not null in controller. ");
            return false;
        }
        if (ipv4FromController.size() != ipv4FromDevice.size()) {
            resultBuilder.setErrorCause(subDomainId.toString() + " number of ipv4 in device is different from controller. " + TestDriverProvider.buildDetailInfo(ipv4FromController, ipv4FromDevice));
            return false;
        }
        int counterEqualIpv4 = 0;
        for (Ipv4 ipv4C : ipv4FromController) {
            for (Ipv4 ipv4D : ipv4FromDevice) {
                if (!ipv4C.getBitstringlength().equals(ipv4D.getBitstringlength()) || !ipv4C.getBierMplsLabelBase().equals((Object)ipv4D.getBierMplsLabelBase())) continue;
                ++counterEqualIpv4;
                if (Objects.equals(ipv4C.getBierMplsLabelRangeSize(), ipv4D.getBierMplsLabelRangeSize())) continue;
                resultBuilder.setErrorCause(subDomainId.toString() + TestDriverProvider.buildDetailInfo(ipv4C, ipv4D));
                return false;
            }
        }
        if (counterEqualIpv4 != ipv4FromController.size()) {
            resultBuilder.setErrorCause(subDomainId.toString() + TestDriverProvider.buildDetailInfo(ipv4FromController, ipv4FromDevice));
            return false;
        }
        return true;
    }

    public boolean compareAf(SubDomainId subDomainId, Af afFromController, Af afFromDevice, ConfigureResultBuilder resultBuilder) {
        if (afFromController == afFromDevice) {
            return true;
        }
        if (afFromController == null) {
            resultBuilder.setErrorCause(subDomainId.toString() + " Af from controller is null while it is not null in device. ");
            return false;
        }
        if (afFromDevice == null) {
            resultBuilder.setErrorCause(subDomainId.toString() + " Af from device is null while it is not null in controller. ");
            return false;
        }
        return this.compareIpv4(subDomainId, afFromController.getIpv4(), afFromDevice.getIpv4(), resultBuilder);
    }

    public boolean compareSubdomain(List<SubDomain> subdomainFromController, List<SubDomain> subdomainFromDevice, ConfigureResultBuilder resultBuilder) {
        if (subdomainFromController == subdomainFromDevice) {
            return true;
        }
        if (subdomainFromController == null) {
            resultBuilder.setErrorCause(" subdomain from controller is null while it is not null in device. ");
            return false;
        }
        if (subdomainFromDevice == null) {
            resultBuilder.setErrorCause(" subdomain from device is null while it is not null in controller. ");
            return false;
        }
        if (subdomainFromController.size() != subdomainFromDevice.size()) {
            resultBuilder.setErrorCause(" number of subdomain in device is different from controller. " + TestDriverProvider.buildDetailInfo(subdomainFromController, subdomainFromDevice));
            return false;
        }
        int counterEqualSubdomainId = 0;
        for (SubDomain subDomainC : subdomainFromController) {
            for (SubDomain subDomainD : subdomainFromDevice) {
                if (!subDomainC.getSubDomainId().equals((Object)subDomainD.getSubDomainId())) continue;
                ++counterEqualSubdomainId;
                if (!Objects.equals(subDomainC.getBfrId(), subDomainD.getBfrId())) {
                    resultBuilder.setErrorCause(" subdomain :" + subDomainC.getSubDomainId().toString() + TestDriverProvider.buildDetailInfo(subDomainC.getBfrId(), subDomainD.getBfrId()));
                    return false;
                }
                if (!Objects.equals(subDomainC.getBitstringlength(), subDomainD.getBitstringlength())) {
                    resultBuilder.setErrorCause(" subdomain :" + subDomainC.getSubDomainId().toString() + TestDriverProvider.buildDetailInfo(subDomainC.getBitstringlength(), subDomainD.getBitstringlength()));
                    return false;
                }
                if (!Objects.equals(subDomainC.getIgpType(), subDomainD.getIgpType())) {
                    resultBuilder.setErrorCause(" subdomain :" + subDomainC.getSubDomainId().toString() + TestDriverProvider.buildDetailInfo(subDomainC.getIgpType(), subDomainD.getIgpType()));
                    return false;
                }
                if (this.compareAf(subDomainC.getSubDomainId(), subDomainC.getAf(), subDomainD.getAf(), resultBuilder)) continue;
                return false;
            }
        }
        if (counterEqualSubdomainId != subdomainFromController.size()) {
            resultBuilder.setErrorCause(TestDriverProvider.buildDetailInfo(subdomainFromController, subdomainFromDevice));
            return false;
        }
        return true;
    }

    public boolean compareBierGlobal(BierGlobal bierGlobalFromController, BierGlobal bierGlobalFromDevice, ConfigureResultBuilder resultBuilder) {
        LOG.info("compareBierGlobal controller:{}, device:{}", (Object)bierGlobalFromController, (Object)bierGlobalFromDevice);
        if (!Objects.equals(bierGlobalFromController.getBitstringlength(), bierGlobalFromDevice.getBitstringlength())) {
            resultBuilder.setErrorCause("BIER global bitstring length ." + TestDriverProvider.buildDetailInfo(bierGlobalFromController.getBitstringlength(), bierGlobalFromDevice.getBitstringlength()));
            return false;
        }
        if (!Objects.equals(bierGlobalFromController.getEncapsulationType(), bierGlobalFromDevice.getEncapsulationType())) {
            resultBuilder.setErrorCause("BIER global encapsulationType ." + TestDriverProvider.buildDetailInfo(bierGlobalFromController.getEncapsulationType(), bierGlobalFromDevice.getEncapsulationType()));
            return false;
        }
        if (!Objects.equals(bierGlobalFromController.getBfrId(), bierGlobalFromDevice.getBfrId())) {
            resultBuilder.setErrorCause("BIER global BFR ID ." + TestDriverProvider.buildDetailInfo(bierGlobalFromController.getBfrId(), bierGlobalFromDevice.getBfrId()));
            return false;
        }
        if (!Objects.equals(bierGlobalFromController.getIpv4BfrPrefix(), bierGlobalFromDevice.getIpv4BfrPrefix())) {
            resultBuilder.setErrorCause("BIER global IPv4 BFR prefix ." + TestDriverProvider.buildDetailInfo(bierGlobalFromController.getIpv4BfrPrefix(), bierGlobalFromDevice.getIpv4BfrPrefix()));
            return false;
        }
        if (!Objects.equals(bierGlobalFromController.getIpv6BfrPrefix(), bierGlobalFromDevice.getIpv6BfrPrefix())) {
            resultBuilder.setErrorCause("BIER global IPv6 BFR prefix ." + TestDriverProvider.buildDetailInfo(bierGlobalFromController.getIpv6BfrPrefix(), bierGlobalFromDevice.getIpv6BfrPrefix()));
            return false;
        }
        return this.compareSubdomain(bierGlobalFromController.getSubDomain(), bierGlobalFromDevice.getSubDomain(), resultBuilder);
    }

    public Future<RpcResult<CheckBierGlobalOutput>> checkBierGlobal(CheckBierGlobalInput input) {
        ConfigureResultBuilder resultBuilder = new ConfigureResultBuilder();
        BierGlobal bierGlobalFromDevice = this.bierConfigReader.readBierGlobal(input.getNodeName());
        BierGlobal bierGlobalFromController = this.readBierGlobalFromController(input.getNodeName());
        boolean isEqual = false;
        if (bierGlobalFromController == null && bierGlobalFromDevice != null) {
            isEqual = false;
            resultBuilder.setErrorCause("bierGlobalFromController is null while bierGlobalFromDevice is not null.");
        } else if (bierGlobalFromController == null && bierGlobalFromDevice == null) {
            isEqual = true;
            resultBuilder.setErrorCause("Both bierGlobalFromController and bierGlobalFromDevice are null.");
        } else if (bierGlobalFromController != null && bierGlobalFromDevice == null) {
            isEqual = false;
            resultBuilder.setErrorCause("bierGlobalFromController is not null while bierGlobalFromDevice is  null.");
        } else {
            isEqual = this.compareBierGlobal(bierGlobalFromController, bierGlobalFromDevice, resultBuilder);
        }
        CheckBierGlobalOutput output = new CheckBierGlobalOutputBuilder().setConfigureResult(resultBuilder.setResult(isEqual ? ConfigureResult.Result.SUCCESS : ConfigureResult.Result.FAILURE).build()).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetChannelOutput>> setChannel(SetChannelInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.channelConfigWrite.writeChannel(type, new ChannelBuilder().setDstGroup(input.getDstGroup()).setSrcTp(input.getSrcTp()).setBierForwardingType(input.getBierForwardingType()).setEgressNode(Lists.transform((List)input.getEgressNode(), (Function)new Function<org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.EgressNode, EgressNode>(){

            public EgressNode apply(org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.EgressNode enode) {
                EgressNodeBuilder egressNodeBuilder = new EgressNodeBuilder();
                if (enode.getRcvTp() != null) {
                    ArrayList<RcvTp> rcvTps = new ArrayList<RcvTp>();
                    for (org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.egress.node.RcvTp rcvTp : enode.getRcvTp()) {
                        rcvTps.add(new RcvTpBuilder().setTp(rcvTp.getTp()).build());
                    }
                    egressNodeBuilder.setRcvTp(rcvTps);
                }
                return new EgressNodeBuilder().setEgressBfrId(new BfrId(enode.getEgressBfrId().getValue())).setNodeId(enode.getNodeId()).build();
            }
        })).setGroupWildcard(input.getGroupWildcard()).setIngressBfrId(input.getIngressBfrId()).setIngressNode(input.getIngressNode()).setSourceWildcard(input.getSourceWildcard()).setSrcIp(input.getSrcIp()).setSubDomainId(input.getSubDomainId()).build());
        SetChannelOutput output = new SetChannelOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetEgressNodeOutput>> setEgressNode(SetEgressNodeInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.channelConfigWrite.writeChannelEgressNode(type, new ChannelBuilder().setDstGroup(input.getDstGroup()).setEgressNode(Collections.singletonList(new EgressNodeBuilder().setEgressBfrId(input.getEgressBfrId()).setNodeId(input.getEgressNode()).build())).setGroupWildcard(input.getGroupWildcard()).setIngressBfrId(input.getIngressBfrId()).setIngressNode(input.getIngressNode()).setSourceWildcard(input.getSourceWildcard()).setSrcIp(input.getSrcIp()).setSubDomainId(input.getSubDomainId()).build());
        SetEgressNodeOutput output = new SetEgressNodeOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    private Channel getChannelByName(String channelName) {
        KeyedInstanceIdentifier multicastInfoIid = IidConstants.BIER_CHANNEL_IID.child(Channel.class, (Identifier)new ChannelKey(channelName));
        return (Channel)DataGetter.readData((DataBroker)this.dataBroker, (InstanceIdentifier)multicastInfoIid, (LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION);
    }

    private List<BfrId> getContollerBrfIdList(Channel channel) {
        List egressNodeList = channel.getEgressNode();
        if (egressNodeList == null || egressNodeList.isEmpty()) {
            return null;
        }
        return Lists.transform((List)egressNodeList, (Function)new Function<EgressNode, BfrId>(){

            public BfrId apply(EgressNode input) {
                return input.getEgressBfrId();
            }
        });
    }

    private List<BfrId> getDeviceBrfIdList(Channel channel) {
        return this.channelConfigReader.readChannel(channel);
    }

    public Future<RpcResult<CheckChannelOutput>> checkChannel(CheckChannelInput input) {
        boolean isEqual;
        Channel channel = this.getChannelByName(input.getChannelName());
        List<BfrId> controllerEgress = this.getContollerBrfIdList(channel);
        List<BfrId> deviceEgress = this.getDeviceBrfIdList(channel);
        String detail = "";
        if (controllerEgress == null && deviceEgress != null) {
            isEqual = false;
            detail = "controllerEgress is null while deviceEgress is not null.";
        } else if (controllerEgress == null && deviceEgress == null) {
            isEqual = true;
            detail = "Both controllerEgress and deviceEgress are null";
        } else if (controllerEgress != null && deviceEgress == null) {
            isEqual = false;
            detail = "controllerEgress is not null while deviceEgress is  null.";
        } else {
            boolean bl = isEqual = controllerEgress.containsAll(deviceEgress) && deviceEgress.containsAll(controllerEgress);
            if (!isEqual) {
                detail = "\n controller egress : " + controllerEgress.toString() + "\n device egress : " + deviceEgress.toString();
            }
        }
        CheckChannelOutput output = new CheckChannelOutputBuilder().setConfigureResult(new ConfigureResultBuilder().setResult(isEqual ? ConfigureResult.Result.SUCCESS : ConfigureResult.Result.FAILURE).setErrorCause(detail).build()).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetTeBiftOutput>> setTeBift(SetTeBiftInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.bierTeBiftWriter.writeTeBift(type, input.getNodeName(), (TeInfo)new BierTeConfigBuilder().setTeSubdomain(input.getTeSubdomain()).build());
        SetTeBiftOutput output = new SetTeBiftOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetLabelRangeOutput>> setLabelRange(SetLabelRangeInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.bierTeLabelRangeConfigWriter.writeBierTeLabelRange(type, input.getNodeName(), new BierTeLableRangeBuilder().setLabelBase(new MplsLabel(input.getLableBase())).setLabelRangeSize(new BierTeLabelRangeSize(input.getLableRange())).build());
        SetLabelRangeOutput output = new SetLabelRangeOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }

    public Future<RpcResult<SetBierTeBitstringOutput>> setBierTeBitstring(SetBierTeBitstringInput input) {
        ConfigurationType type = this.getConfigurationType(input.getWriteType());
        ConfigurationResult result = this.bierTeBitstringWriter.writeBierTeBitstring(type, input.getNodeName(), (TePath)new PathBuilder().setPathId(input.getPathId()).setSubdomainId(input.getSubdomainId()).setBitstringlength(input.getBitstringlength()).setSi(input.getSi()).setBitstring(input.getBitstring()).build());
        SetBierTeBitstringOutput output = new SetBierTeBitstringOutputBuilder().setConfigureResult(this.buildResult(result)).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }
}

