/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetIpv4ConfigInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierMplsCfg;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierMplsLabelRangeSize;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.mpls.rev160705.MplsLabel;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetIpv4ConfigInputBuilder
implements Builder<SetIpv4ConfigInput> {
    private MplsLabel _bierMplsLabelBase;
    private BierMplsLabelRangeSize _bierMplsLabelRangeSize;
    private Integer _bitstringlength;
    private Integer _domainId;
    private String _nodeName;
    private Integer _subDomainId;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>> augmentation = Collections.emptyMap();

    public SetIpv4ConfigInputBuilder() {
    }

    public SetIpv4ConfigInputBuilder(BierMplsCfg arg) {
        this._bitstringlength = arg.getBitstringlength();
        this._bierMplsLabelBase = arg.getBierMplsLabelBase();
        this._bierMplsLabelRangeSize = arg.getBierMplsLabelRangeSize();
    }

    public SetIpv4ConfigInputBuilder(SetIpv4ConfigInput base) {
        AugmentationHolder casted;
        this._bierMplsLabelBase = base.getBierMplsLabelBase();
        this._bierMplsLabelRangeSize = base.getBierMplsLabelRangeSize();
        this._bitstringlength = base.getBitstringlength();
        this._domainId = base.getDomainId();
        this._nodeName = base.getNodeName();
        this._subDomainId = base.getSubDomainId();
        this._writeType = base.getWriteType();
        if (base instanceof SetIpv4ConfigInputImpl) {
            SetIpv4ConfigInputImpl impl = (SetIpv4ConfigInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof BierMplsCfg) {
            this._bitstringlength = ((BierMplsCfg)arg).getBitstringlength();
            this._bierMplsLabelBase = ((BierMplsCfg)arg).getBierMplsLabelBase();
            this._bierMplsLabelRangeSize = ((BierMplsCfg)arg).getBierMplsLabelRangeSize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BierMplsCfg] \nbut was: " + arg);
        }
    }

    public MplsLabel getBierMplsLabelBase() {
        return this._bierMplsLabelBase;
    }

    public BierMplsLabelRangeSize getBierMplsLabelRangeSize() {
        return this._bierMplsLabelRangeSize;
    }

    public Integer getBitstringlength() {
        return this._bitstringlength;
    }

    public Integer getDomainId() {
        return this._domainId;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public Integer getSubDomainId() {
        return this._subDomainId;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetIpv4ConfigInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetIpv4ConfigInputBuilder setBierMplsLabelBase(MplsLabel value) {
        this._bierMplsLabelBase = value;
        return this;
    }

    public SetIpv4ConfigInputBuilder setBierMplsLabelRangeSize(BierMplsLabelRangeSize value) {
        this._bierMplsLabelRangeSize = value;
        return this;
    }

    private static void checkBitstringlengthRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public SetIpv4ConfigInputBuilder setBitstringlength(Integer value) {
        if (value != null) {
            SetIpv4ConfigInputBuilder.checkBitstringlengthRange(value);
        }
        this._bitstringlength = value;
        return this;
    }

    private static void checkDomainIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public SetIpv4ConfigInputBuilder setDomainId(Integer value) {
        if (value != null) {
            SetIpv4ConfigInputBuilder.checkDomainIdRange(value);
        }
        this._domainId = value;
        return this;
    }

    public SetIpv4ConfigInputBuilder setNodeName(String value) {
        this._nodeName = value;
        return this;
    }

    private static void checkSubDomainIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public SetIpv4ConfigInputBuilder setSubDomainId(Integer value) {
        if (value != null) {
            SetIpv4ConfigInputBuilder.checkSubDomainIdRange(value);
        }
        this._subDomainId = value;
        return this;
    }

    public SetIpv4ConfigInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetIpv4ConfigInputBuilder addAugmentation(Class<? extends Augmentation<SetIpv4ConfigInput>> augmentationType, Augmentation<SetIpv4ConfigInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetIpv4ConfigInputBuilder removeAugmentation(Class<? extends Augmentation<SetIpv4ConfigInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetIpv4ConfigInput build() {
        return new SetIpv4ConfigInputImpl(this);
    }

    private static final class SetIpv4ConfigInputImpl
    implements SetIpv4ConfigInput {
        private final MplsLabel _bierMplsLabelBase;
        private final BierMplsLabelRangeSize _bierMplsLabelRangeSize;
        private final Integer _bitstringlength;
        private final Integer _domainId;
        private final String _nodeName;
        private final Integer _subDomainId;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetIpv4ConfigInput> getImplementedInterface() {
            return SetIpv4ConfigInput.class;
        }

        private SetIpv4ConfigInputImpl(SetIpv4ConfigInputBuilder base) {
            this._bierMplsLabelBase = base.getBierMplsLabelBase();
            this._bierMplsLabelRangeSize = base.getBierMplsLabelRangeSize();
            this._bitstringlength = base.getBitstringlength();
            this._domainId = base.getDomainId();
            this._nodeName = base.getNodeName();
            this._subDomainId = base.getSubDomainId();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>>(base.augmentation);
                }
            }
        }

        public MplsLabel getBierMplsLabelBase() {
            return this._bierMplsLabelBase;
        }

        public BierMplsLabelRangeSize getBierMplsLabelRangeSize() {
            return this._bierMplsLabelRangeSize;
        }

        public Integer getBitstringlength() {
            return this._bitstringlength;
        }

        @Override
        public Integer getDomainId() {
            return this._domainId;
        }

        @Override
        public String getNodeName() {
            return this._nodeName;
        }

        @Override
        public Integer getSubDomainId() {
            return this._subDomainId;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetIpv4ConfigInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bierMplsLabelBase);
            result = 31 * result + Objects.hashCode(this._bierMplsLabelRangeSize);
            result = 31 * result + Objects.hashCode(this._bitstringlength);
            result = 31 * result + Objects.hashCode(this._domainId);
            result = 31 * result + Objects.hashCode(this._nodeName);
            result = 31 * result + Objects.hashCode(this._subDomainId);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetIpv4ConfigInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetIpv4ConfigInput other = (SetIpv4ConfigInput)obj;
            if (!Objects.equals(this._bierMplsLabelBase, other.getBierMplsLabelBase())) {
                return false;
            }
            if (!Objects.equals(this._bierMplsLabelRangeSize, other.getBierMplsLabelRangeSize())) {
                return false;
            }
            if (!Objects.equals(this._bitstringlength, other.getBitstringlength())) {
                return false;
            }
            if (!Objects.equals(this._domainId, other.getDomainId())) {
                return false;
            }
            if (!Objects.equals(this._nodeName, other.getNodeName())) {
                return false;
            }
            if (!Objects.equals(this._subDomainId, other.getSubDomainId())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetIpv4ConfigInputImpl otherImpl = (SetIpv4ConfigInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetIpv4ConfigInput>>, Augmentation<SetIpv4ConfigInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetIpv4ConfigInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bierMplsLabelBase != null) {
                builder.append("_bierMplsLabelBase=");
                builder.append(this._bierMplsLabelBase);
                builder.append(", ");
            }
            if (this._bierMplsLabelRangeSize != null) {
                builder.append("_bierMplsLabelRangeSize=");
                builder.append(this._bierMplsLabelRangeSize);
                builder.append(", ");
            }
            if (this._bitstringlength != null) {
                builder.append("_bitstringlength=");
                builder.append(this._bitstringlength);
                builder.append(", ");
            }
            if (this._domainId != null) {
                builder.append("_domainId=");
                builder.append(this._domainId);
                builder.append(", ");
            }
            if (this._nodeName != null) {
                builder.append("_nodeName=");
                builder.append(this._nodeName);
                builder.append(", ");
            }
            if (this._subDomainId != null) {
                builder.append("_subDomainId=");
                builder.append(this._subDomainId);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

