/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.BierForwardingType;
import org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel;
import org.opendaylight.yang.gen.v1.urn.bier.common.rev161102.DomainId;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.ConfigType;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.SetChannelInput;
import org.opendaylight.yang.gen.v1.urn.bier.test.driver.rev161219.set.channel.input.EgressNode;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.BfrId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.bier.rev160723.SubDomainId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetChannelInputBuilder
implements Builder<SetChannelInput> {
    private BierForwardingType _bierForwardingType;
    private DomainId _domainId;
    private IpAddress _dstGroup;
    private List<EgressNode> _egressNode;
    private Short _groupWildcard;
    private BfrId _ingressBfrId;
    private String _ingressNode;
    private String _name;
    private Short _sourceWildcard;
    private IpAddress _srcIp;
    private String _srcTp;
    private SubDomainId _subDomainId;
    private ConfigType _writeType;
    Map<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>> augmentation = Collections.emptyMap();

    public SetChannelInputBuilder() {
    }

    public SetChannelInputBuilder(Channel arg) {
        this._name = arg.getName();
        this._srcIp = arg.getSrcIp();
        this._dstGroup = arg.getDstGroup();
        this._domainId = arg.getDomainId();
        this._subDomainId = arg.getSubDomainId();
        this._sourceWildcard = arg.getSourceWildcard();
        this._groupWildcard = arg.getGroupWildcard();
    }

    public SetChannelInputBuilder(SetChannelInput base) {
        AugmentationHolder casted;
        this._bierForwardingType = base.getBierForwardingType();
        this._domainId = base.getDomainId();
        this._dstGroup = base.getDstGroup();
        this._egressNode = base.getEgressNode();
        this._groupWildcard = base.getGroupWildcard();
        this._ingressBfrId = base.getIngressBfrId();
        this._ingressNode = base.getIngressNode();
        this._name = base.getName();
        this._sourceWildcard = base.getSourceWildcard();
        this._srcIp = base.getSrcIp();
        this._srcTp = base.getSrcTp();
        this._subDomainId = base.getSubDomainId();
        this._writeType = base.getWriteType();
        if (base instanceof SetChannelInputImpl) {
            SetChannelInputImpl impl = (SetChannelInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Channel) {
            this._name = ((Channel)arg).getName();
            this._srcIp = ((Channel)arg).getSrcIp();
            this._dstGroup = ((Channel)arg).getDstGroup();
            this._domainId = ((Channel)arg).getDomainId();
            this._subDomainId = ((Channel)arg).getSubDomainId();
            this._sourceWildcard = ((Channel)arg).getSourceWildcard();
            this._groupWildcard = ((Channel)arg).getGroupWildcard();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.bier.channel.rev161102.Channel] \nbut was: " + arg);
        }
    }

    public BierForwardingType getBierForwardingType() {
        return this._bierForwardingType;
    }

    public DomainId getDomainId() {
        return this._domainId;
    }

    public IpAddress getDstGroup() {
        return this._dstGroup;
    }

    public List<EgressNode> getEgressNode() {
        return this._egressNode;
    }

    public Short getGroupWildcard() {
        return this._groupWildcard;
    }

    public BfrId getIngressBfrId() {
        return this._ingressBfrId;
    }

    public String getIngressNode() {
        return this._ingressNode;
    }

    public String getName() {
        return this._name;
    }

    public Short getSourceWildcard() {
        return this._sourceWildcard;
    }

    public IpAddress getSrcIp() {
        return this._srcIp;
    }

    public String getSrcTp() {
        return this._srcTp;
    }

    public SubDomainId getSubDomainId() {
        return this._subDomainId;
    }

    public ConfigType getWriteType() {
        return this._writeType;
    }

    public <E extends Augmentation<SetChannelInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetChannelInputBuilder setBierForwardingType(BierForwardingType value) {
        this._bierForwardingType = value;
        return this;
    }

    public SetChannelInputBuilder setDomainId(DomainId value) {
        this._domainId = value;
        return this;
    }

    public SetChannelInputBuilder setDstGroup(IpAddress value) {
        this._dstGroup = value;
        return this;
    }

    public SetChannelInputBuilder setEgressNode(List<EgressNode> value) {
        this._egressNode = value;
        return this;
    }

    private static void checkGroupWildcardRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SetChannelInputBuilder setGroupWildcard(Short value) {
        if (value != null) {
            SetChannelInputBuilder.checkGroupWildcardRange(value);
        }
        this._groupWildcard = value;
        return this;
    }

    public SetChannelInputBuilder setIngressBfrId(BfrId value) {
        this._ingressBfrId = value;
        return this;
    }

    public SetChannelInputBuilder setIngressNode(String value) {
        this._ingressNode = value;
        return this;
    }

    public SetChannelInputBuilder setName(String value) {
        this._name = value;
        return this;
    }

    private static void checkSourceWildcardRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SetChannelInputBuilder setSourceWildcard(Short value) {
        if (value != null) {
            SetChannelInputBuilder.checkSourceWildcardRange(value);
        }
        this._sourceWildcard = value;
        return this;
    }

    public SetChannelInputBuilder setSrcIp(IpAddress value) {
        this._srcIp = value;
        return this;
    }

    public SetChannelInputBuilder setSrcTp(String value) {
        this._srcTp = value;
        return this;
    }

    public SetChannelInputBuilder setSubDomainId(SubDomainId value) {
        this._subDomainId = value;
        return this;
    }

    public SetChannelInputBuilder setWriteType(ConfigType value) {
        this._writeType = value;
        return this;
    }

    public SetChannelInputBuilder addAugmentation(Class<? extends Augmentation<SetChannelInput>> augmentationType, Augmentation<SetChannelInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SetChannelInputBuilder removeAugmentation(Class<? extends Augmentation<SetChannelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetChannelInput build() {
        return new SetChannelInputImpl(this);
    }

    private static final class SetChannelInputImpl
    implements SetChannelInput {
        private final BierForwardingType _bierForwardingType;
        private final DomainId _domainId;
        private final IpAddress _dstGroup;
        private final List<EgressNode> _egressNode;
        private final Short _groupWildcard;
        private final BfrId _ingressBfrId;
        private final String _ingressNode;
        private final String _name;
        private final Short _sourceWildcard;
        private final IpAddress _srcIp;
        private final String _srcTp;
        private final SubDomainId _subDomainId;
        private final ConfigType _writeType;
        private Map<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetChannelInput> getImplementedInterface() {
            return SetChannelInput.class;
        }

        private SetChannelInputImpl(SetChannelInputBuilder base) {
            this._bierForwardingType = base.getBierForwardingType();
            this._domainId = base.getDomainId();
            this._dstGroup = base.getDstGroup();
            this._egressNode = base.getEgressNode();
            this._groupWildcard = base.getGroupWildcard();
            this._ingressBfrId = base.getIngressBfrId();
            this._ingressNode = base.getIngressNode();
            this._name = base.getName();
            this._sourceWildcard = base.getSourceWildcard();
            this._srcIp = base.getSrcIp();
            this._srcTp = base.getSrcTp();
            this._subDomainId = base.getSubDomainId();
            this._writeType = base.getWriteType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>>(base.augmentation);
                }
            }
        }

        @Override
        public BierForwardingType getBierForwardingType() {
            return this._bierForwardingType;
        }

        public DomainId getDomainId() {
            return this._domainId;
        }

        public IpAddress getDstGroup() {
            return this._dstGroup;
        }

        @Override
        public List<EgressNode> getEgressNode() {
            return this._egressNode;
        }

        public Short getGroupWildcard() {
            return this._groupWildcard;
        }

        @Override
        public BfrId getIngressBfrId() {
            return this._ingressBfrId;
        }

        @Override
        public String getIngressNode() {
            return this._ingressNode;
        }

        public String getName() {
            return this._name;
        }

        public Short getSourceWildcard() {
            return this._sourceWildcard;
        }

        public IpAddress getSrcIp() {
            return this._srcIp;
        }

        @Override
        public String getSrcTp() {
            return this._srcTp;
        }

        public SubDomainId getSubDomainId() {
            return this._subDomainId;
        }

        @Override
        public ConfigType getWriteType() {
            return this._writeType;
        }

        public <E extends Augmentation<SetChannelInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bierForwardingType);
            result = 31 * result + Objects.hashCode(this._domainId);
            result = 31 * result + Objects.hashCode(this._dstGroup);
            result = 31 * result + Objects.hashCode(this._egressNode);
            result = 31 * result + Objects.hashCode(this._groupWildcard);
            result = 31 * result + Objects.hashCode(this._ingressBfrId);
            result = 31 * result + Objects.hashCode(this._ingressNode);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sourceWildcard);
            result = 31 * result + Objects.hashCode(this._srcIp);
            result = 31 * result + Objects.hashCode(this._srcTp);
            result = 31 * result + Objects.hashCode(this._subDomainId);
            result = 31 * result + Objects.hashCode((Object)this._writeType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetChannelInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetChannelInput other = (SetChannelInput)obj;
            if (!Objects.equals(this._bierForwardingType, other.getBierForwardingType())) {
                return false;
            }
            if (!Objects.equals(this._domainId, other.getDomainId())) {
                return false;
            }
            if (!Objects.equals(this._dstGroup, other.getDstGroup())) {
                return false;
            }
            if (!Objects.equals(this._egressNode, other.getEgressNode())) {
                return false;
            }
            if (!Objects.equals(this._groupWildcard, other.getGroupWildcard())) {
                return false;
            }
            if (!Objects.equals(this._ingressBfrId, other.getIngressBfrId())) {
                return false;
            }
            if (!Objects.equals(this._ingressNode, other.getIngressNode())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sourceWildcard, other.getSourceWildcard())) {
                return false;
            }
            if (!Objects.equals(this._srcIp, other.getSrcIp())) {
                return false;
            }
            if (!Objects.equals(this._srcTp, other.getSrcTp())) {
                return false;
            }
            if (!Objects.equals(this._subDomainId, other.getSubDomainId())) {
                return false;
            }
            if (!Objects.equals((Object)this._writeType, (Object)other.getWriteType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetChannelInputImpl otherImpl = (SetChannelInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetChannelInput>>, Augmentation<SetChannelInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetChannelInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bierForwardingType != null) {
                builder.append("_bierForwardingType=");
                builder.append(this._bierForwardingType);
                builder.append(", ");
            }
            if (this._domainId != null) {
                builder.append("_domainId=");
                builder.append(this._domainId);
                builder.append(", ");
            }
            if (this._dstGroup != null) {
                builder.append("_dstGroup=");
                builder.append(this._dstGroup);
                builder.append(", ");
            }
            if (this._egressNode != null) {
                builder.append("_egressNode=");
                builder.append(this._egressNode);
                builder.append(", ");
            }
            if (this._groupWildcard != null) {
                builder.append("_groupWildcard=");
                builder.append(this._groupWildcard);
                builder.append(", ");
            }
            if (this._ingressBfrId != null) {
                builder.append("_ingressBfrId=");
                builder.append(this._ingressBfrId);
                builder.append(", ");
            }
            if (this._ingressNode != null) {
                builder.append("_ingressNode=");
                builder.append(this._ingressNode);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sourceWildcard != null) {
                builder.append("_sourceWildcard=");
                builder.append(this._sourceWildcard);
                builder.append(", ");
            }
            if (this._srcIp != null) {
                builder.append("_srcIp=");
                builder.append(this._srcIp);
                builder.append(", ");
            }
            if (this._srcTp != null) {
                builder.append("_srcTp=");
                builder.append(this._srcTp);
                builder.append(", ");
            }
            if (this._subDomainId != null) {
                builder.append("_subDomainId=");
                builder.append(this._subDomainId);
                builder.append(", ");
            }
            if (this._writeType != null) {
                builder.append("_writeType=");
                builder.append((Object)this._writeType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

