/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.conditionparser;

import org.antlr.v4.runtime.tree.TerminalNode;
import org.opencastproject.workflow.conditionparser.Atom;
import org.opencastproject.workflow.conditionparser.ComparisonOperator;
import org.opencastproject.workflow.conditionparser.NumericalOperator;
import org.opencastproject.workflow.conditionparser.antlr.WorkflowConditionBaseVisitor;
import org.opencastproject.workflow.conditionparser.antlr.WorkflowConditionParser;

public final class WorkflowConditionBooleanInterpreter
extends WorkflowConditionBaseVisitor<Boolean> {
    @Override
    public Boolean visitBooleanTerm(WorkflowConditionParser.BooleanTermContext ctx) {
        boolean base = (Boolean)this.visit(ctx.booleanValue());
        if (ctx.booleanTerm() != null) {
            return base && (Boolean)this.visit(ctx.booleanTerm()) != false;
        }
        return base;
    }

    @Override
    public Boolean visitRelationOperand(WorkflowConditionParser.RelationOperandContext ctx) {
        return null;
    }

    @Override
    public Boolean visitBooleanValue(WorkflowConditionParser.BooleanValueContext ctx) {
        boolean invert;
        boolean bl = invert = ctx.NOT() != null && ctx.NOT().size() % 2 != 0;
        boolean result = ctx.BOOL() != null ? Boolean.parseBoolean(ctx.BOOL().getText()) : (ctx.booleanExpression() != null ? ((Boolean)this.visit(ctx.booleanExpression())).booleanValue() : this.visitRelation(ctx.relation()).booleanValue());
        if (invert) {
            return !result;
        }
        return result;
    }

    @Override
    public Boolean visitAtom(WorkflowConditionParser.AtomContext ctx) {
        return null;
    }

    @Override
    public Boolean visitBooleanExpression(WorkflowConditionParser.BooleanExpressionContext ctx) {
        boolean base = (Boolean)this.visit(ctx.booleanTerm());
        if (ctx.booleanExpression() != null) {
            return base || (Boolean)this.visit(ctx.booleanExpression()) != false;
        }
        return base;
    }

    @Override
    public Boolean visitRelation(WorkflowConditionParser.RelationContext ctx) {
        Atom left = this.visitRelationOperandProduceAtom(ctx.relationOperand(0));
        Atom right = this.visitRelationOperandProduceAtom(ctx.relationOperand(1));
        switch (ComparisonOperator.parseComparisonOperator(ctx.COMPARISONOPERATOR().getText())) {
            case LE: {
                return left.compareTo(right) <= 0;
            }
            case LT: {
                return left.compareTo(right) < 0;
            }
            case EQ: {
                return left.compareTo(right) == 0;
            }
            case NE: {
                return left.compareTo(right) != 0;
            }
            case GT: {
                return left.compareTo(right) > 0;
            }
        }
        return left.compareTo(right) >= 0;
    }

    private Atom visitRelationOperandProduceAtom(WorkflowConditionParser.RelationOperandContext ctx) {
        Atom base = this.visitAtomProduceAtom(ctx.atom(0));
        for (int i = 1; i < ctx.atom().size(); ++i) {
            TerminalNode operator = ctx.NUMERICALOPERATOR(i - 1);
            base = base.reduce(this.visitAtomProduceAtom(ctx.atom(i)), NumericalOperator.parseNumericalOperator(operator.getText()));
        }
        return base;
    }

    private Atom visitAtomProduceAtom(WorkflowConditionParser.AtomContext ctx) {
        if (ctx.NUMBER() != null) {
            return Atom.parseNumber(ctx.NUMBER().getText());
        }
        if (ctx.STRING() != null) {
            String replaced = ctx.STRING().getText().replace("''", "'");
            return Atom.parseString(replaced.substring(1, replaced.length() - 1));
        }
        if (ctx.BOOL() != null) {
            String replaced = ctx.BOOL().getText();
            return Atom.fromString(replaced);
        }
        return this.visitRelationOperandProduceAtom(ctx.relationOperand());
    }
}

