/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.waveform.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.waveform.api.WaveformService;
import org.opencastproject.waveform.api.WaveformServiceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/waveform")
@RestService(name="WaveformServiceEndpoint", title="Waveform Service REST Endpoint", abstractText="The Waveform Service generates a waveform image from a media file with at least one audio channel.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/waveform)"})
@Component(immediate=true, service={WaveformServiceEndpoint.class}, property={"service.description=Waveform Service REST Endpoint", "opencast.service.type=org.opencastproject.waveform", "opencast.service.path=/waveform", "opencast.service.jobproducer=true"})
@JaxrsResource
public class WaveformServiceEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WaveformServiceEndpoint.class);
    private ServiceRegistry serviceRegistry = null;
    private WaveformService waveformService = null;

    @POST
    @Path(value="/create")
    @Produces(value={"application/xml"})
    @RestQuery(name="create", description="Create a waveform image from the given track", returnDescription="Media package attachment for the generated waveform.", restParameters={@RestParameter(name="track", type=RestParameter.Type.TEXT, description="Track with at least one audio channel.", isRequired=true), @RestParameter(name="pixelsPerMinute", type=RestParameter.Type.INTEGER, description="Width of waveform image in pixels per minute.", isRequired=true), @RestParameter(name="minWidth", type=RestParameter.Type.INTEGER, description="Minimum width of waveform image.", isRequired=true), @RestParameter(name="maxWidth", type=RestParameter.Type.INTEGER, description="Maximum width of waveform image.", isRequired=true), @RestParameter(name="height", type=RestParameter.Type.INTEGER, description="Height of waveform image.", isRequired=true), @RestParameter(name="color", type=RestParameter.Type.STRING, defaultValue="black", description="Color of waveform image.", isRequired=true)}, responses={@RestResponse(description="Waveform generation job successfully created.", responseCode=200), @RestResponse(description="The given track can't be parsed.", responseCode=400), @RestResponse(description="Internal server error.", responseCode=500)})
    public Response createWaveformImage(@FormParam(value="track") String track, @FormParam(value="pixelsPerMinute") int pixelsPerMinute, @FormParam(value="minWidth") int minWidth, @FormParam(value="maxWidth") int maxWidth, @FormParam(value="height") int height, @FormParam(value="color") String color) {
        try {
            MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)track);
            if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Track element must be of type track").build();
            }
            Job job = this.waveformService.createWaveformImage((Track)sourceTrack, pixelsPerMinute, minWidth, maxWidth, height, color);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (WaveformServiceException ex) {
            logger.error("Creating waveform job for track {} failed:", (Object)track, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (MediaPackageException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Track element parsing failure").build();
        }
    }

    public JobProducer getService() {
        if (this.waveformService instanceof JobProducer) {
            return (JobProducer)this.waveformService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setWaveformService(WaveformService waveformService) {
        this.waveformService = waveformService;
    }
}

