/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.uiconfig;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Paths;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="UIConfigEndpoint", title="UI Config Endpoint", abstractText="Serves the configuration of the UI", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated.In other words, there is a bug! You should file an error report with your server logs from the timewhen the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(property={"service.description=UI Config REST Endpoint", "opencast.service.type=org.opencastproject.uiconfig", "opencast.service.path=/ui/config"}, immediate=true, service={UIConfigRest.class})
public class UIConfigRest {
    private static final Logger logger = LoggerFactory.getLogger(UIConfigRest.class);
    static final String UI_CONFIG_FOLDER_PROPERTY = "org.opencastproject.uiconfig.folder";
    static final String X_ACCEL_REDIRECT_PROPERTY = "X-Accel-Redirect";
    private static final String UI_CONFIG_FOLDER_DEFAULT = "ui-config";
    private String uiConfigFolder = null;
    private String xAccelRedirect = null;
    private SecurityService securityService;

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    @Modified
    public void activate(BundleContext context, Map<String, String> properties) throws ConfigurationException, IOException {
        this.uiConfigFolder = properties.get(UI_CONFIG_FOLDER_PROPERTY);
        logger.debug("UI configuration folder configured as '{}'", (Object)this.uiConfigFolder);
        if (StringUtils.isNotEmpty((CharSequence)this.uiConfigFolder)) {
            this.uiConfigFolder = new File(this.uiConfigFolder).getCanonicalPath();
        } else {
            String karafEtc = context.getProperty("karaf.etc");
            if (StringUtils.isBlank((CharSequence)karafEtc)) {
                throw new ConfigurationException(String.format("%s not set and unable to fall back to default location based on ${karaf.etc}", UI_CONFIG_FOLDER_PROPERTY));
            }
            this.uiConfigFolder = new File(karafEtc, UI_CONFIG_FOLDER_DEFAULT).getCanonicalPath();
        }
        logger.debug("UI configuration folder set to '{}'", (Object)this.uiConfigFolder);
        this.xAccelRedirect = properties.get(X_ACCEL_REDIRECT_PROPERTY);
        logger.debug("X-Accel-Redirect path set to {}", (Object)this.xAccelRedirect);
    }

    @GET
    @Path(value="{component}/{filename : .+}")
    @Produces(value={"*/*"})
    @RestQuery(name="getConfigFile", description="Returns the requested configuration file (json, css, etc..)", pathParameters={@RestParameter(description="Name of the component, which the configuration file belongs to", isRequired=true, name="component", type=RestParameter.Type.STRING), @RestParameter(description="Name of the configuration file", isRequired=true, name="filename", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="the requested configuration file", responseCode=200), @RestResponse(description="if the configuration file doesn't exist", responseCode=404)}, returnDescription="")
    public Response getConfigFile(@PathParam(value="component") String component, @PathParam(value="filename") String filename) throws IOException, NotFoundException {
        String orgId = this.securityService.getOrganization().getId();
        File configFile = Paths.get(this.uiConfigFolder, orgId, component, filename).toFile();
        try {
            String basePath = new File(this.uiConfigFolder, orgId).getCanonicalPath();
            String configFileCanPath = configFile.getCanonicalPath();
            if (!configFileCanPath.startsWith(basePath)) {
                logger.debug("Directory traversal prevented (trying to access '{}')", (Object)configFile.getPath());
                throw new AccessDeniedException(configFileCanPath);
            }
            if (!configFile.exists()) {
                logger.debug("Falling back to default organization");
                configFile = Paths.get(this.uiConfigFolder, "mh_default_org", component, filename).toFile();
            }
            if (this.xAccelRedirect != null) {
                String relative = Paths.get(this.uiConfigFolder, new String[0]).relativize(configFile.toPath()).toString();
                return Response.noContent().header(X_ACCEL_REDIRECT_PROPERTY, (Object)Paths.get(this.xAccelRedirect, relative).toString()).build();
            }
            return Response.ok((Object)new FileInputStream(configFile)).header("Content-Length", (Object)configFile.length()).header("Content-Type", (Object)MimeTypes.getMimeType((String)filename)).build();
        }
        catch (FileNotFoundException e) {
            logger.debug("Could not find requested configuration file '{}'", (Object)configFile.getPath(), (Object)e);
            throw new NotFoundException();
        }
    }
}

