/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.terminationstate.api;

import org.opencastproject.job.api.Job;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.terminationstate.api.TerminationStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobTerminationStateService
implements TerminationStateService {
    private TerminationStateService.TerminationState state = TerminationStateService.TerminationState.NONE;
    private ServiceRegistry serviceRegistry;
    private final Logger logger = LoggerFactory.getLogger((String)AbstractJobTerminationStateService.class.getName());

    @Override
    public void setState(TerminationStateService.TerminationState state) {
        this.state = state;
        this.logger.info("Termination state set to {}", (Object)state.toString());
    }

    @Override
    public TerminationStateService.TerminationState getState() {
        return this.state;
    }

    protected long countJobs() throws ServiceRegistryException {
        String host = "";
        long nJobs = 0L;
        try {
            host = this.serviceRegistry.getRegistryHostname();
            nJobs = this.serviceRegistry.countByHost(null, host, Job.Status.RUNNING);
        }
        catch (ServiceRegistryException ex) {
            this.logger.error("Cannot count jobs running on {}", (Object)host, (Object)ex);
            throw ex;
        }
        return nJobs;
    }

    protected boolean readyToTerminate() {
        block5: {
            if (this.state == TerminationStateService.TerminationState.WAIT) {
                try {
                    if (this.countJobs() == 0L) {
                        this.state = TerminationStateService.TerminationState.READY;
                        return true;
                    }
                    break block5;
                }
                catch (ServiceRegistryException ex) {
                    this.logger.warn("Can't determine number of running Jobs, setting Termination State to READ");
                    this.state = TerminationStateService.TerminationState.READY;
                    return true;
                }
            }
            if (this.state == TerminationStateService.TerminationState.READY) {
                return true;
            }
        }
        return false;
    }

    public void setServiceRegistry(ServiceRegistry service) {
        this.serviceRegistry = service;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

