/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.subtitleparser;

import java.util.ArrayList;
import java.util.List;

public abstract class SubtitleCue {
    private String id;
    private long startTime;
    private long endTime;
    private List<String> lines;

    protected SubtitleCue(SubtitleCue cue) {
        this.id = cue.getId();
        this.startTime = cue.getStartTime();
        this.endTime = cue.getEndTime();
        this.lines = cue.getLines();
    }

    protected SubtitleCue() {
        this.lines = new ArrayList<String>();
    }

    protected SubtitleCue(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.lines = new ArrayList<String>();
    }

    protected SubtitleCue(long startTime, long endTime, List<String> lines) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.lines = lines;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public String getText() {
        CharSequence[] lineArray = this.lines.toArray(new String[this.lines.size()]);
        return String.join((CharSequence)"\n", lineArray);
    }

    public String toString() {
        return this.getText();
    }
}

