/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.util;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workflows {
    private static final Logger logger = LoggerFactory.getLogger(Workflows.class);
    private final AssetManager am;
    private final WorkflowService wfs;
    private final Fn<Snapshot, MediaPackage> getMediapackage = new Fn<Snapshot, MediaPackage>(){

        public MediaPackage apply(Snapshot snapshot) {
            return snapshot.getMediaPackage();
        }
    };
    private final Fn<String, Iterable<Snapshot>> findLatest = new Fn<String, Iterable<Snapshot>>(){

        public Iterable<Snapshot> apply(String mpId) {
            AQueryBuilder q = Workflows.this.am.createQuery();
            return Enrichments.enrich((AResult)q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().isLatest())).run()).getSnapshots();
        }
    };

    public Workflows(AssetManager am, WorkflowService wfs) {
        this.am = am;
        this.wfs = wfs;
    }

    public Stream<WorkflowInstance> applyWorkflowToLatestVersion(Iterable<String> mpIds, ConfiguredWorkflow wf) {
        return Stream.$(mpIds).bind(this.findLatest).map(this.getMediapackage).bind(this.applyWorkflow(wf));
    }

    public Fn<MediaPackage, Opt<WorkflowInstance>> applyWorkflow(final ConfiguredWorkflow wf) {
        return new Fn<MediaPackage, Opt<WorkflowInstance>>(){

            public Opt<WorkflowInstance> apply(MediaPackage mp) {
                try {
                    return Opt.some((Object)Workflows.this.wfs.start(wf.getWorkflowDefinition(), mp, wf.getParameters()));
                }
                catch (UnauthorizedException | WorkflowDatabaseException | WorkflowParsingException e) {
                    logger.error("Cannot start workflow on media package " + mp.getIdentifier().toString(), e);
                    return Opt.none();
                }
            }
        };
    }
}

