/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.notification;

import java.util.ArrayList;
import java.util.Objects;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.email.template.api.EmailTemplateService;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.kernel.mail.SmtpService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Sends an email with the parameters indicated", "workflow.operation=send-email"})
public class EmailWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(EmailWorkflowOperationHandler.class);
    private SmtpService smtpService = null;
    private EmailTemplateService emailTemplateService = null;
    private UserDirectoryService userDirectoryService;
    static final String TO_PROPERTY = "to";
    static final String CC_PROPERTY = "cc";
    static final String BCC_PROPERTY = "bcc";
    static final String SUBJECT_PROPERTY = "subject";
    static final String BODY_PROPERTY = "body";
    static final String BODY_TEMPLATE_FILE_PROPERTY = "body-template-file";
    static final String BODY_HTML_PROPERTY = "body-html";
    static final String BODY_HTML_TEMPLATE_FILE_PROPERTY = "body-html-template-file";
    static final String ADDRESS_SEPARATOR_PROPERTY = "address-separator";
    static final String ADDRESS_SEPARATOR_DEFAULT = ", \t";
    static final String SKIP_INVALID_ADDRESS_PROPERTY = "skip-invalid-address";

    protected void activate(ComponentContext cc) {
        super.activate(cc);
        logger.debug("Activating email workflow operation handler");
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        String[] bcc;
        String[] cc;
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackage srcPackage = workflowInstance.getMediaPackage();
        String[] to = this.processDestination(workflowInstance, operation, TO_PROPERTY);
        if (to.length + (cc = this.processDestination(workflowInstance, operation, CC_PROPERTY)).length + (bcc = this.processDestination(workflowInstance, operation, BCC_PROPERTY)).length == 0) {
            logger.info("No recipients. Skipping operation.");
            return this.createResult(srcPackage, WorkflowOperationResult.Action.SKIP);
        }
        String subject = this.applyTemplateIfNecessary(workflowInstance, operation, SUBJECT_PROPERTY);
        String bodyCfg = operation.getConfiguration(BODY_PROPERTY);
        String bodyTemplateFileCfg = operation.getConfiguration(BODY_TEMPLATE_FILE_PROPERTY);
        String bodyHtmlCfg = operation.getConfiguration(BODY_HTML_PROPERTY);
        String bodyHtmlTemplateFileCfg = operation.getConfiguration(BODY_HTML_TEMPLATE_FILE_PROPERTY);
        String bodyText = null;
        String bodyHTML = null;
        if (bodyCfg == null && bodyHtmlCfg == null && bodyTemplateFileCfg == null && bodyHtmlTemplateFileCfg == null) {
            bodyText = String.format("%s (%s)", srcPackage.getTitle(), srcPackage.getIdentifier());
        }
        if (bodyCfg != null) {
            bodyText = this.applyTemplateIfNecessary(workflowInstance, operation, BODY_PROPERTY);
        } else if (bodyTemplateFileCfg != null) {
            bodyText = this.applyTemplateIfNecessary(workflowInstance, operation, BODY_TEMPLATE_FILE_PROPERTY);
        }
        if (bodyHtmlCfg != null) {
            bodyHTML = this.applyTemplateIfNecessary(workflowInstance, operation, BODY_HTML_PROPERTY);
        } else if (bodyHtmlTemplateFileCfg != null) {
            bodyHTML = this.applyTemplateIfNecessary(workflowInstance, operation, BODY_HTML_TEMPLATE_FILE_PROPERTY);
        }
        try {
            logger.debug("Sending e-mail notification with subject '{}' and text body '{}' / HTML body '{}' to '{}', CC '{}' and BCC '{}'", new Object[]{subject, bodyText, bodyHTML, to, cc, bcc});
            this.smtpService.send(to, cc, bcc, subject, bodyText, bodyHTML);
            logger.info("E-mail notification sent to {}, CC addresses {} and BCC addresses {}", new Object[]{to, cc, bcc});
        }
        catch (MessagingException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        return this.createResult(srcPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private String[] processDestination(WorkflowInstance workflowInstance, WorkflowOperationInstance operation, String emailHeader) throws WorkflowOperationException {
        String separator = Objects.toString(operation.getConfiguration(ADDRESS_SEPARATOR_PROPERTY), ADDRESS_SEPARATOR_DEFAULT);
        String templateApplied = this.applyTemplateIfNecessary(workflowInstance, operation, emailHeader, separator);
        if (templateApplied == null) {
            return new String[0];
        }
        ArrayList<String> recipients = new ArrayList<String>();
        boolean skipInvalid = BooleanUtils.toBoolean((String)operation.getConfiguration(SKIP_INVALID_ADDRESS_PROPERTY));
        for (String part : StringUtils.split((String)templateApplied, (String)separator)) {
            User user = this.userDirectoryService.loadUser(part);
            if (user != null && StringUtils.isNotEmpty((CharSequence)user.getEmail())) {
                recipients.add(user.getEmail());
                continue;
            }
            try {
                new InternetAddress(part).validate();
                recipients.add(part);
            }
            catch (Exception e) {
                if (skipInvalid) {
                    logger.debug("Skip sending mail to invalid email address {}", (Object)part);
                    continue;
                }
                throw new WorkflowOperationException(String.format("Email address invalid or user doesn't have an email: %s.", part), (Throwable)e);
            }
        }
        return recipients.toArray(new String[0]);
    }

    private String applyTemplateIfNecessary(WorkflowInstance workflowInstance, WorkflowOperationInstance operation, String configName) {
        return this.applyTemplateIfNecessary(workflowInstance, operation, configName, null);
    }

    private String applyTemplateIfNecessary(WorkflowInstance workflowInstance, WorkflowOperationInstance operation, String configName, String separator) {
        String configValue = operation.getConfiguration(configName);
        Object templateName = null;
        String templateContent = null;
        if (BODY_TEMPLATE_FILE_PROPERTY.equals(configName) || BODY_HTML_TEMPLATE_FILE_PROPERTY.equals(configName)) {
            templateName = configValue;
        } else if (configValue != null && configValue.contains("${")) {
            templateName = workflowInstance.getTemplate() + "_" + operation.getId() + "_" + configName;
            templateName = ((String)templateName).replaceAll("[^A-Za-z0-9 ]", "_");
            templateContent = configValue;
        } else {
            return configValue;
        }
        if (separator == null) {
            return this.emailTemplateService.applyTemplate((String)templateName, templateContent, workflowInstance);
        }
        return this.emailTemplateService.applyTemplate((String)templateName, templateContent, workflowInstance, separator);
    }

    @Reference
    void setSmtpService(SmtpService smtpService) {
        this.smtpService = smtpService;
    }

    @Reference
    void setEmailTemplateService(EmailTemplateService service) {
        this.emailTemplateService = service;
    }

    @Reference
    void setUserDirectoryService(UserDirectoryService service) {
        this.userDirectoryService = service;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

