/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.api.util;

import org.apache.commons.lang3.StringUtils;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.api.MediaPackageMetadata;

public final class MediaPackageMetadataSupport {
    private MediaPackageMetadataSupport() {
    }

    public static void populateMediaPackageMetadata(MediaPackage mp, MediaPackageMetadata metadata) {
        if (metadata == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getSeriesIdentifier())) {
            mp.setSeries(metadata.getSeriesIdentifier());
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getSeriesTitle())) {
            mp.setSeriesTitle(metadata.getSeriesTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getTitle())) {
            mp.setTitle(metadata.getTitle());
        }
        if (metadata.getDate() != null) {
            mp.setDate(metadata.getDate());
        }
        if (metadata.getSubjects().length > 0) {
            if (mp.getSubjects() != null) {
                for (String subject : mp.getSubjects()) {
                    mp.removeSubject(subject);
                }
            }
            for (String subject : metadata.getSubjects()) {
                mp.addSubject(subject);
            }
        }
        if (metadata.getContributors().length > 0) {
            if (mp.getContributors() != null) {
                for (String contributor : mp.getContributors()) {
                    mp.removeContributor(contributor);
                }
            }
            for (String contributor : metadata.getContributors()) {
                mp.addContributor(contributor);
            }
        }
        if (mp.getCreators().length == 0 && metadata.getCreators().length > 0) {
            if (mp.getCreators() != null) {
                for (String creator : mp.getCreators()) {
                    mp.removeCreator(creator);
                }
            }
            for (String creator : metadata.getCreators()) {
                mp.addCreator(creator);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getLicense())) {
            mp.setLicense(metadata.getLicense());
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getLanguage())) {
            mp.setLanguage(metadata.getLanguage());
        }
    }
}

