/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.springframework.security.core.Authentication;

public class AuthenticationSuccessHandler
implements org.springframework.security.web.authentication.AuthenticationSuccessHandler {
    public static final String WILDCARD = "*";
    public static final String ROOT = "/";
    private SecurityService securityService = null;
    private Map<String, String> welcomePages = null;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        if ("application/json".equalsIgnoreCase(request.getHeader("Accept"))) {
            response.sendRedirect("/info/me.json");
            return;
        }
        HttpSession session = request.getSession();
        String initialRequestUri = (String)session.getAttribute("initial_request_path");
        session.removeAttribute("initial_request_path");
        if (initialRequestUri != null) {
            response.sendRedirect(initialRequestUri);
            return;
        }
        if (this.welcomePages == null || this.welcomePages.isEmpty()) {
            response.sendRedirect(ROOT);
            return;
        }
        User currentUser = this.securityService.getUser();
        for (Role role : currentUser.getRoles()) {
            if (!this.welcomePages.containsKey(role.getName())) continue;
            response.sendRedirect(this.welcomePages.get(role.getName()));
            return;
        }
        response.sendRedirect(this.welcomePages.getOrDefault(WILDCARD, ROOT));
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setWelcomePages(Map<String, String> welcomePages) {
        this.welcomePages = welcomePages;
    }
}

