/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.ThrowableCauseExtractor;
import org.springframework.web.filter.GenericFilterBean;

public class AsyncTimeoutRedirectFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTimeoutRedirectFilter.class);
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private static final int TIMEOUT_ERROR_CODE = 419;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
            logger.debug("Chain processed normally");
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
            AuthenticationException exception = (AuthenticationException)this.throwableAnalyzer.getFirstThrowableOfType(AuthenticationException.class, causeChain);
            if (exception == null && (exception = (AccessDeniedException)this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain)) != null) {
                if (this.authenticationTrustResolver.isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                    logger.debug("User session expired or not logged in yet");
                    String ajaxHeader = ((HttpServletRequest)request).getHeader("X-Requested-With");
                    if ("XMLHttpRequest".equals(ajaxHeader)) {
                        logger.debug("Asynchronous call detected, send {} error code", (Object)419);
                        HttpServletResponse resp = (HttpServletResponse)response;
                        resp.sendError(419);
                        return;
                    }
                }
                logger.debug("Redirect to login page");
                throw exception;
            }
            throw ex;
        }
    }

    private static final class DefaultThrowableAnalyzer
    extends ThrowableAnalyzer {
        private DefaultThrowableAnalyzer() {
        }

        protected void initExtractorMap() {
            super.initExtractorMap();
            this.registerExtractor(ServletException.class, new ThrowableCauseExtractor(){

                public Throwable extractCause(Throwable throwable) {
                    ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, ServletException.class);
                    return ((ServletException)throwable).getRootCause();
                }
            });
        }
    }
}

