/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.util.statistics;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.external.util.statistics.DataResolutionUtils;
import org.opencastproject.external.util.statistics.DetailLevelUtils;
import org.opencastproject.external.util.statistics.ResourceTypeUtils;
import org.opencastproject.external.util.statistics.StatisticsProviderUtils;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.api.StatisticsService;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.statistics.export.api.DetailLevel;

public final class QueryUtils {
    private QueryUtils() {
    }

    public static List<Query> parse(String queryString, StatisticsService statisticsService) {
        JSONArray queriesJson;
        if (StringUtils.isBlank((CharSequence)queryString)) {
            throw new IllegalArgumentException("No query data provided");
        }
        JSONParser parser = new JSONParser();
        try {
            queriesJson = (JSONArray)parser.parse(queryString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("JSON malformed");
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        queriesJson.forEach(item -> {
            Query query = QueryUtils.parseQuery((JSONObject)item, statisticsService);
            queries.add(query);
        });
        return queries;
    }

    public static Query parseQuery(String queryString, StatisticsService statisticsService) {
        JSONObject queryJson;
        if (StringUtils.isBlank((CharSequence)queryString)) {
            throw new IllegalArgumentException("No query data provided");
        }
        JSONParser parser = new JSONParser();
        try {
            queryJson = (JSONObject)parser.parse(queryString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("JSON malformed");
        }
        return QueryUtils.parseQuery(queryJson, statisticsService);
    }

    private static Query parseQuery(JSONObject queryJson, StatisticsService statisticsService) {
        JSONObject providerJson = (JSONObject)queryJson.get((Object)"provider");
        String providerId = QueryUtils.getField(providerJson, "identifier", "Identifier of provider is missing");
        Optional provider = statisticsService.getProvider(providerId);
        if (!provider.isPresent()) {
            throw new IllegalArgumentException("Provider not found");
        }
        JSONObject parametersJson = (JSONObject)queryJson.get((Object)"parameters");
        Parameters parameters = QueryUtils.parseParameters(parametersJson, (StatisticsProvider)provider.get());
        return new Query((StatisticsProvider)provider.get(), parameters);
    }

    public static Parameters parseParameters(JSONObject parametersJson, StatisticsProvider provider) {
        Parameters result;
        String resourceId = QueryUtils.getField(parametersJson, "resourceId", "Parameter 'resourceId' is missing");
        if (provider instanceof TimeSeriesProvider) {
            TimeSeriesParameters p;
            if (parametersJson.containsKey((Object)"detailLevel")) {
                p = new ExportParameters(resourceId, parametersJson);
                ((ExportParameters)p).setDetailLevel(QueryUtils.getField(parametersJson, "detailLevel", "Parameter 'detailLevel' is misisng"));
            } else {
                p = new TimeSeriesParameters(resourceId, parametersJson);
            }
            p.setFrom(QueryUtils.getField(parametersJson, "from", "Parameter 'from' is missing"));
            p.setTo(QueryUtils.getField(parametersJson, "to", "Parameter 'to' is missing"));
            p.setDataResolution(QueryUtils.getField(parametersJson, "dataResolution", "Parameter 'dataResolution' is missing"));
            result = p;
        } else {
            result = new Parameters(resourceId, parametersJson);
        }
        result.validate();
        return result;
    }

    private static String getField(JSONObject object, String field, String exceptionMessage) {
        String value;
        try {
            value = (String)object.get((Object)field);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        return value;
    }

    public static JSONObject execute(Query query) {
        QueryResult result;
        StatisticsProvider provider = query.getProvider();
        if (provider instanceof TimeSeriesProvider) {
            TimeSeriesParameters p = (TimeSeriesParameters)query.getParameters();
            TimeSeriesProvider tsp = (TimeSeriesProvider)provider;
            TimeSeries timeseries = tsp.getValues(p.getResourceId(), p.getFrom(), p.getTo(), p.getDataResolution(), ZoneId.systemDefault());
            result = new QueryResultTimeSeries(query, timeseries);
        } else {
            result = new QueryResult(query);
        }
        return result.get();
    }

    public static class ExportParameters
    extends TimeSeriesParameters {
        private DetailLevel detailLevel;

        ExportParameters(String resourceId, JSONObject raw) {
            super(resourceId, raw);
        }

        void setDetailLevel(String detailLevel) {
            Optional<DetailLevel> level = DetailLevelUtils.fromString(detailLevel);
            if (!level.isPresent()) {
                throw new IllegalArgumentException("Illegal value for 'detailLevel'");
            }
            this.detailLevel = level.get();
        }

        public DetailLevel getDetailLevel() {
            return this.detailLevel;
        }
    }

    public static class TimeSeriesParameters
    extends Parameters {
        private Instant from;
        private Instant to;
        private DataResolution dataResolution;

        TimeSeriesParameters(String resourceId, JSONObject raw) {
            super(resourceId, raw);
        }

        public Instant getFrom() {
            return this.from;
        }

        void setFrom(String from) {
            try {
                this.from = Instant.parse(from);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Parameter 'from' not in ISO 8601 UTC format");
            }
        }

        public Instant getTo() {
            return this.to;
        }

        void setTo(String to) {
            try {
                this.to = Instant.parse(to);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Parameter 'to' not in ISO 8601 UTC format");
            }
        }

        public DataResolution getDataResolution() {
            return this.dataResolution;
        }

        void setDataResolution(String dataResolution) {
            Optional<DataResolution> resolution = DataResolutionUtils.fromString(dataResolution);
            if (!resolution.isPresent()) {
                throw new IllegalArgumentException("Illegal value for 'resolution'");
            }
            this.dataResolution = resolution.get();
        }

        @Override
        void validate() {
            super.validate();
            if (this.to.compareTo(this.from) <= 0) {
                throw new IllegalArgumentException("'from' date must be before 'to' date");
            }
        }
    }

    public static class Parameters {
        private String resourceId;
        private JSONObject raw;

        Parameters(String resourceId, JSONObject raw) {
            this.resourceId = resourceId;
            this.raw = raw;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public JSONObject get() {
            return this.raw;
        }

        void validate() {
        }
    }

    public static class QueryResultTimeSeries
    extends QueryResult {
        QueryResultTimeSeries(Query query, TimeSeries timeseries) {
            super(query);
            this.data.put((Object)"labels", (Object)timeseries.getLabels());
            this.data.put((Object)"values", (Object)timeseries.getValues());
            if (timeseries.getTotal().isPresent()) {
                this.data.put((Object)"total", (Object)timeseries.getTotal().getAsDouble());
            }
        }
    }

    public static class QueryResult {
        private Query query;
        protected JSONObject data;

        QueryResult(Query query) {
            this.query = query;
            this.data = new JSONObject();
        }

        public JSONObject getData() {
            return this.data;
        }

        public JSONObject get() {
            JSONObject result = new JSONObject();
            JSONObject providerObj = new JSONObject();
            providerObj.put((Object)"identifier", (Object)this.query.getProvider().getId());
            providerObj.put((Object)"type", (Object)StatisticsProviderUtils.typeOf(this.query.getProvider()));
            providerObj.put((Object)"resourceType", (Object)ResourceTypeUtils.toString(this.query.getProvider().getResourceType()));
            result.put((Object)"provider", (Object)providerObj);
            result.put((Object)"parameters", (Object)this.query.getParameters().get());
            result.put((Object)"data", (Object)this.getData());
            return result;
        }
    }

    public static class Query {
        private StatisticsProvider provider;
        private Parameters parameters;

        Query(StatisticsProvider provider, Parameters parameters) {
            this.provider = provider;
            this.parameters = parameters;
        }

        public StatisticsProvider getProvider() {
            return this.provider;
        }

        public Parameters getParameters() {
            return this.parameters;
        }
    }
}

