/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.external.common.ApiMediaType;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.external.common.ApiVersion;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowStateException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapiworkflowinstances", title="External API Workflow Instances Service", notes={}, abstractText="Provides resources and operations related to the workflow instances")
@Component(immediate=true, service={WorkflowsEndpoint.class}, property={"service.description=External API - Workflow Instances Endpoint", "opencast.service.type=org.opencastproject.external.workflows.instances", "opencast.service.path=/api/workflows"})
public class WorkflowsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowsEndpoint.class);
    protected String endpointBaseUrl;
    private WorkflowService workflowService;
    private ElasticsearchIndex elasticsearchIndex;
    private IndexService indexService;

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Workflow Instances Endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc, (String)"org.opencastproject.external.api.url", (String)"opencast.service.path");
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
        logger.debug("Configured service endpoint is {}", (Object)this.endpointBaseUrl);
    }

    @POST
    @Path(value="")
    @RestQuery(name="createworkflowinstance", description="Creates a workflow instance.", returnDescription="", restParameters={@RestParameter(name="event_identifier", description="The event identifier this workflow should run against", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="workflow_definition_identifier", description="The identifier of the workflow definition to use", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="configuration", description="The optional configuration for this workflow", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="withoperations", description="Whether the workflow operations should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfiguration", description="Whether the workflow configuration should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="A new workflow is created and its identifier is returned in the Location header.", responseCode=201), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400), @RestResponse(description="The event or workflow definition could not be found.", responseCode=404)})
    public Response createWorkflowInstance(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="event_identifier") String eventId, @FormParam(value="workflow_definition_identifier") String workflowDefinitionIdentifier, @FormParam(value="configuration") String configuration, @QueryParam(value="withoperations") boolean withOperations, @QueryParam(value="withconfiguration") boolean withConfiguration) {
        if (StringUtils.isBlank((CharSequence)eventId)) {
            return RestUtil.R.badRequest((String)"Required parameter 'event_identifier' is missing or invalid");
        }
        if (StringUtils.isBlank((CharSequence)workflowDefinitionIdentifier)) {
            return RestUtil.R.badRequest((String)"Required parameter 'workflow_definition_identifier' is missing or invalid");
        }
        try {
            WorkflowDefinition wd;
            Opt event = this.indexService.getEvent(eventId, this.elasticsearchIndex);
            if (event.isNone()) {
                return ApiResponses.notFound("Cannot find an event with id '%s'.", eventId);
            }
            MediaPackage mp = this.indexService.getEventMediapackage((Event)event.get());
            try {
                wd = this.workflowService.getWorkflowDefinitionById(workflowDefinitionIdentifier);
            }
            catch (NotFoundException e) {
                return ApiResponses.notFound("Cannot find a workflow definition with id '%s'.", workflowDefinitionIdentifier);
            }
            HashMap properties = new HashMap();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{configuration})) {
                JSONParser parser = new JSONParser();
                try {
                    properties.putAll((JSONObject)parser.parse(configuration));
                }
                catch (ParseException e) {
                    return RestUtil.R.badRequest((String)"Passed parameter 'configuration' is invalid JSON.");
                }
            }
            WorkflowInstance wi = this.workflowService.start(wd, mp, null, properties);
            return ApiResponses.Json.created(acceptHeader, URI.create(this.getWorkflowUrl(wi.getId())), this.workflowInstanceToJSON(wi, withOperations, withConfiguration));
        }
        catch (IllegalStateException e) {
            ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
            return ApiResponses.Json.conflict(requestedVersion, (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"message", (JValue)Jsons.v((Object)e.getMessage(), (JValue)Jsons.BLANK))}));
        }
        catch (Exception e) {
            logger.error("Could not create workflow instances", (Throwable)e);
            return ApiResponses.serverError("Could not create workflow instances, reason: '%s'", e.getMessage());
        }
    }

    @GET
    @Path(value="{workflowInstanceId}")
    @RestQuery(name="getworkflowinstance", description="Returns a single workflow instance.", returnDescription="", pathParameters={@RestParameter(name="workflowInstanceId", description="The workflow instance id", isRequired=true, type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(name="withoperations", description="Whether the workflow operations should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfiguration", description="Whether the workflow configuration should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The workflow instance is returned.", responseCode=200), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The specified workflow instance does not exist.", responseCode=404)})
    public Response getWorkflowInstance(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="workflowInstanceId") Long id, @QueryParam(value="withoperations") boolean withOperations, @QueryParam(value="withconfiguration") boolean withConfiguration) {
        WorkflowInstance wi;
        try {
            wi = this.workflowService.getWorkflowById(id.longValue());
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find workflow instance with id '%d'.", id);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (Exception e) {
            logger.error("The workflow service was not able to get the workflow instance", (Throwable)e);
            return ApiResponses.serverError("Could not retrieve workflow instance, reason: '%s'", e.getMessage());
        }
        return ApiResponses.Json.ok(acceptHeader, this.workflowInstanceToJSON(wi, withOperations, withConfiguration));
    }

    @PUT
    @Path(value="{workflowInstanceId}")
    @RestQuery(name="updateworkflowinstance", description="Creates a workflow instance.", returnDescription="", pathParameters={@RestParameter(name="workflowInstanceId", description="The workflow instance id", isRequired=true, type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(name="configuration", description="The optional configuration for this workflow", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="state", description="The optional state transition for this workflow", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="withoperations", description="Whether the workflow operations should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN), @RestParameter(name="withconfiguration", description="Whether the workflow configuration should be included in the response", isRequired=false, type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="The workflow instance is updated.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The workflow instance could not be found.", responseCode=404), @RestResponse(description="The workflow instance cannot transition to this state.", responseCode=409)})
    public Response updateWorkflowInstance(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="workflowInstanceId") Long id, @FormParam(value="configuration") String configuration, @FormParam(value="state") String stateStr, @QueryParam(value="withoperations") boolean withOperations, @QueryParam(value="withconfiguration") boolean withConfiguration) {
        try {
            boolean changed = false;
            WorkflowInstance wi = this.workflowService.getWorkflowById(id.longValue());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{configuration})) {
                JSONParser parser = new JSONParser();
                try {
                    HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)((JSONObject)parser.parse(configuration)));
                    wi.getConfigurationKeys().forEach(arg_0 -> ((WorkflowInstance)wi).removeConfiguration(arg_0));
                    properties.forEach((arg_0, arg_1) -> ((WorkflowInstance)wi).setConfiguration(arg_0, arg_1));
                    changed = true;
                }
                catch (ParseException e) {
                    return RestUtil.R.badRequest((String)"Passed parameter 'configuration' is invalid JSON.");
                }
            }
            if (changed) {
                this.workflowService.update(wi);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{stateStr})) {
                WorkflowInstance.WorkflowState state;
                try {
                    state = this.jsonToEnum(WorkflowInstance.WorkflowState.class, stateStr);
                }
                catch (IllegalArgumentException e) {
                    return RestUtil.R.badRequest((String)String.format("Invalid workflow state '%s'", stateStr));
                }
                WorkflowInstance.WorkflowState currentState = wi.getState();
                if (state != currentState) {
                    switch (state) {
                        case PAUSED: {
                            this.workflowService.suspend(wi.getId());
                            break;
                        }
                        case STOPPED: {
                            this.workflowService.stop(wi.getId());
                            break;
                        }
                        case RUNNING: {
                            if (currentState == WorkflowInstance.WorkflowState.INSTANTIATED || currentState == WorkflowInstance.WorkflowState.PAUSED) {
                                this.workflowService.resume(wi.getId());
                                break;
                            }
                            return RestUtil.R.conflict((String)String.format("Cannot resume from workflow state '%s'", currentState.toString().toLowerCase()));
                        }
                        default: {
                            return RestUtil.R.conflict((String)String.format("Cannot transition state from '%s' to '%s'", currentState.toString().toLowerCase(), stateStr));
                        }
                    }
                }
            }
            wi = this.workflowService.getWorkflowById(id.longValue());
            return ApiResponses.Json.ok(acceptHeader, this.workflowInstanceToJSON(wi, withOperations, withConfiguration));
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find workflow instance with id '%d'.", id);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (Exception e) {
            logger.error("The workflow service was not able to get the workflow instance", (Throwable)e);
            return ApiResponses.serverError("Could not retrieve workflow instance, reason: '%s'", e.getMessage());
        }
    }

    @DELETE
    @Path(value="{workflowInstanceId}")
    @RestQuery(name="deleteworkflowinstance", description="Deletes a workflow instance.", returnDescription="", pathParameters={@RestParameter(name="workflowInstanceId", description="The workflow instance id", isRequired=true, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="The workflow instance has been deleted.", responseCode=204), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The specified workflow instance does not exist.", responseCode=404), @RestResponse(description="The workflow instance cannot be deleted in this state.", responseCode=409)})
    public Response deleteWorkflowInstance(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="workflowInstanceId") Long id) {
        try {
            this.workflowService.remove(id.longValue());
        }
        catch (WorkflowStateException e) {
            return RestUtil.R.conflict((String)"Cannot delete workflow instance in this workflow state");
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find workflow instance with id '%d'.", id);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (Exception e) {
            logger.error("Could not delete workflow instances", (Throwable)e);
            return ApiResponses.serverError("Could not delete workflow instances, reason: '%s'", e.getMessage());
        }
        return Response.noContent().build();
    }

    private JValue workflowInstanceToJSON(WorkflowInstance wi, boolean withOperations, boolean withConfiguration) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((Number)wi.getId())));
        fields.add(Jsons.f((String)"title", (JValue)Jsons.v((Object)wi.getTitle(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)wi.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"workflow_definition_identifier", (JValue)Jsons.v((Object)wi.getTemplate(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"event_identifier", (JValue)Jsons.v((String)wi.getMediaPackage().getIdentifier().toString())));
        fields.add(Jsons.f((String)"creator", (JValue)Jsons.v((String)wi.getCreatorName())));
        fields.add(Jsons.f((String)"state", (JValue)this.enumToJSON((Enum)wi.getState())));
        if (withOperations) {
            fields.add(Jsons.f((String)"operations", (JValue)Jsons.arr((Iterable)wi.getOperations().stream().map(this::workflowOperationInstanceToJSON).collect(Collectors.toList()))));
        }
        if (withConfiguration) {
            fields.add(Jsons.f((String)"configuration", (JValue)Jsons.obj((Iterable)wi.getConfigurationKeys().stream().map(key -> Jsons.f((String)key, (String)wi.getConfiguration(key))).collect(Collectors.toList()))));
        }
        return Jsons.obj(fields);
    }

    private JValue workflowOperationInstanceToJSON(WorkflowOperationInstance woi) {
        ArrayList<Field> fields = new ArrayList<Field>();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE_TIME;
        fields.add(Jsons.f((String)"identifier", (JValue)Jsons.v((Object)woi.getId(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"operation", (JValue)Jsons.v((String)woi.getTemplate())));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)woi.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"state", (JValue)this.enumToJSON((Enum)woi.getState())));
        fields.add(Jsons.f((String)"time_in_queue", (JValue)Jsons.v((Object)woi.getTimeInQueue(), (JValue)Jsons.ZERO)));
        fields.add(Jsons.f((String)"host", (JValue)Jsons.v((Object)woi.getExecutionHost(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"if", (JValue)Jsons.v((Object)woi.getExecutionCondition(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"fail_workflow_on_error", (JValue)Jsons.v((Boolean)woi.isFailOnError())));
        fields.add(Jsons.f((String)"error_handler_workflow", (JValue)Jsons.v((Object)woi.getExceptionHandlingWorkflow(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"retry_strategy", (JValue)Jsons.v((Object)new RetryStrategy.Adapter().marshal(woi.getRetryStrategy()), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"max_attempts", (JValue)Jsons.v((Number)woi.getMaxAttempts())));
        fields.add(Jsons.f((String)"failed_attempts", (JValue)Jsons.v((Number)woi.getFailedAttempts())));
        fields.add(Jsons.f((String)"configuration", (JValue)Jsons.obj((Iterable)woi.getConfigurationKeys().stream().map(key -> Jsons.f((String)key, (String)woi.getConfiguration(key))).collect(Collectors.toList()))));
        if (woi.getDateStarted() != null) {
            fields.add(Jsons.f((String)"start", (JValue)Jsons.v((String)dateFormatter.format(woi.getDateStarted().toInstant().atZone(ZoneOffset.UTC)))));
        } else {
            fields.add(Jsons.f((String)"start", (JValue)Jsons.BLANK));
        }
        if (woi.getDateCompleted() != null) {
            fields.add(Jsons.f((String)"completion", (JValue)Jsons.v((String)dateFormatter.format(woi.getDateCompleted().toInstant().atZone(ZoneOffset.UTC)))));
        } else {
            fields.add(Jsons.f((String)"completion", (JValue)Jsons.BLANK));
        }
        return Jsons.obj(fields);
    }

    private JValue enumToJSON(Enum e) {
        return e == null ? null : Jsons.v((String)e.toString().toLowerCase());
    }

    private <T extends Enum<T>> T jsonToEnum(Class<T> enumType, String name) {
        return Enum.valueOf(enumType, name.toUpperCase());
    }

    private String getWorkflowUrl(long workflowInstanceId) {
        return UrlSupport.concat((String)this.endpointBaseUrl, (String)Long.toString(workflowInstanceId));
    }
}

